package pluto.util.xml;

import org.w3c.dom.Document;

import lombok.extern.slf4j.Slf4j;

/**
 * Wraps the Xerces DOM parser and extends NonValidatingDOMParser
 * 
 * @version $id$
 */
@Slf4j
public class DOMParser {

	private static javax.xml.parsers.DocumentBuilderFactory	__INNER_BUILDER_FACTORY__	= null;

	private static javax.xml.parsers.DocumentBuilder		__INNER_BUILDER_INSTANCE__	= null;

	static {
		try {
			__INNER_BUILDER_FACTORY__ = javax.xml.parsers.DocumentBuilderFactory.newInstance();
			__INNER_BUILDER_FACTORY__.setValidating(true);
			__INNER_BUILDER_INSTANCE__ = __INNER_BUILDER_FACTORY__.newDocumentBuilder();
			__INNER_BUILDER_INSTANCE__.setErrorHandler(new eMsXmlErrorHandler());
			if (log.isDebugEnabled()) {
				log.debug(__INNER_BUILDER_INSTANCE__.getClass().getName());
			}
		}
		catch(Exception e) {
			log.error("init error", e.getMessage());
			System.exit(1);
		}
	}

	public synchronized static Document getDocumentFromUrl(String url) throws Exception {
		return __INNER_BUILDER_INSTANCE__.parse(url);
	}

	public synchronized static Document getEmptyDocument() throws Exception {
		return __INNER_BUILDER_INSTANCE__.newDocument();
	}
}
