/*
 * SampleWorker.java
 *
 * Created on 2003년 8월 20일 수, 오후 5:10
 */

package pluto.util.recycle;

import lombok.extern.slf4j.Slf4j;
/**
 *
 * @author  Administrator
 */
@Slf4j
public class SampleWorker extends Thread implements Recycleable {
	private boolean alive = true;
	private boolean work = false;
	protected ObjectPool pool = null;
	
	/** Creates a new instance of SampleWorker */
	public SampleWorker( ObjectPool p , String name ) {
		super( name );
		pool = p;
	}
	
	public void execute(){
		log.info(" execute from=>".concat( Thread.currentThread().getName() ) );
		
		this.work = true;
		synchronized( this ) {
			notifyAll();
		}
	}
	
	public void run(){
		this.alive = true;
		
		synchronized( this ) {
			this.notifyAll();
		}
		
		work();
		
		log.info(" is die.... " );
		/**영원히 사라진다.
		 */
		destroy();
	}
	
	public void work(){
		while (this.alive) {
			try {
				while ( !work ) {
					synchronized( this ){
						wait(30000);
					}
					if( !this.alive ) return;
				}
			}
			catch (InterruptedException ignored){
				log.error("InterruptedException",ignored);
				Thread.currentThread().interrupt();
			}
			
			if( !this.alive ) return;
			
			try {
				log.debug(" WORK....... " );
			}
			catch( Exception e ) {
				log.error( getName() , e );
			}
			catch (ThreadDeath death) {
				log.error( getName() + " is Death : " + death.toString() );
				this.alive = false;
				Thread.currentThread().interrupt();
			}
			catch (Throwable error) {
				log.error( " is catch Throwable : " + error.toString() );
			}
			
			if( !this.alive ) return;
			recycle();
		}
	}
	
	/** 재활용에 들어가기전에 사용한 자원을 반환
	 */
	public void clean() {
		this.work = false;
	}
	
	/** 재활용에 들어가기
	 */
	public void recycle() {
		clean();
		pool.recycle( this );
	}
	
	/** 더이상 안쓴다고 명시한다.
	 */
	public void setRecycleBin(RecycleBin bin) {
		log.info( getName(), " setEnd from=>".concat( Thread.currentThread().getName() ) );
		this.alive=false;
		synchronized( this ){
			notifyAll();
		}
	}
	
	public void destroy() {
		log.info( getName(), " destroy from=>".concat( Thread.currentThread().getName() ) );
		pool.destroy( this );
	}
/** 더이상 안쓴다고 명시한다.
 */	
	public void setEnd(){
	}
}
