/*
 * SampleBufferedPool.java
 *
 * Created on 2003년 11월 20일 (목), 오후 5:55
 */

package pluto.util.recycle;

import lombok.extern.slf4j.Slf4j;

/**
 *
 * @author  t??
 */
@Slf4j
public class SampleBufferedPool extends BufferedObjectPool{
	
	
	/** Creates a new instance of SampleBufferedPool */
	public SampleBufferedPool() throws Exception{
		this.LOG_CHANNEL_INSTANCE = new pluto.log.DebugLogChannel( "c:/work/out.log" , false );
	}
	
	protected Bufferable create(int seq, int level) throws Exception {
		if (log.isDebugEnabled())  log.debug("INTO CREATE METHOD");
		Bufferable returnValue = new SampleBufferable( level );
		if (log.isDebugEnabled())  log.debug("CREATE INSTANCE");
		returnValue.setBufferBin( this );
		if (log.isDebugEnabled())  log.debug("CREATE SUCCESS AND RETURN => " + returnValue.getName() );
		return returnValue;
	}

	public static void main( String[] arg ) throws Exception{
		SampleBufferedPool pool = new SampleBufferedPool();
		
		pool.resetWorkerSize( 10 );
		
		for( int i = 0 ; i < 500 ; i++ ){
			pool.push( "DRAGON#".concat( String.valueOf( i ) ) );
		}
		
		try{ Thread.currentThread().sleep( 10000 ); }catch( Exception e ){ log.error(e.getMessage());}
		
		pool.flush();
		
		System.exit( 1 );
	}
	
	/** 상속받은 Class에서 실제적으로 모니터링하는 로직
	 */
	protected void check() throws Exception {
	}
	
	public void flush() throws Exception {
	}

	@Override
	public void log(String log) {
	}
	
}
