/*
 * SampleBufferable.java
 *
 * Created on 2003년 11월 20일 (목), 오후 5:59
 */

package pluto.util.recycle;

import java.util.Stack;

import lombok.extern.slf4j.Slf4j;

/**
 *
 * @author  t??
 */
@Slf4j
public class SampleBufferable implements Bufferable,Runnable {
	BufferBin INNER_BUFFERED_BIN = null;
	String name = null;
	boolean alive = false;
	
	Stack RCPT_TO = new Stack();
	
	/** Creates a new instance of SampleBufferable */
	public SampleBufferable( int level ) {
		name = "W#".concat( String.valueOf( level ) );
	}
	
	/** 재활용에 들어가기전에 사용한 자원을 반환
	 */
	public void clean() {
		RCPT_TO.clear();
	}
	
	/** 재활용 되지 않고 삭제 될때 자원 정리
	 */
	public void destroy() {
		log.error(" Call destroy Method... from : " + Thread.currentThread().getName() );
		this.clean();
		this.INNER_BUFFERED_BIN.destroy( this );
	}
	
	/** 이름을 반환한다.
	 */
	public String getName() {
		return this.name;
	}
	
	/** 자신을 관리하는 쓰레기 통을 지정한다.
	 */
	public void setBufferBin(BufferBin bin) {
		this.INNER_BUFFERED_BIN = bin;
	}
	
	/** 더이상 안쓴다고 명시한다.
	 */
	public void setEnd() {
		log.error(" Call setEnd Method... from : " + Thread.currentThread().getName() );
		this.alive = false;
		synchronized( this ) {
			this.notifyAll();
		}
	}
	
	/** 폴링을 시작하도록 한다.
	 */
	public void execute() {
		Thread a = new Thread( this , getName() );
		a.start();
	}
	
	public void run() {
		this.alive = true;
		
		synchronized( this ) {
			this.notifyAll();
		}
		
		while (this.alive) {
			this.RCPT_TO.clear();
			
			Object rcpt = null;
			
			while( rcpt == null && this.alive ){
				this.INNER_BUFFERED_BIN.log( getName() + "==> into bins popup " );
				rcpt = this.INNER_BUFFERED_BIN.popup();
				if( rcpt == null ) {
					continue;
				}
				this.INNER_BUFFERED_BIN.log( getName() + "==> out bins popup " );
				this.RCPT_TO.push( rcpt );
			}
			
			if( rcpt == null && this.RCPT_TO.size() == 0 ) {
				continue;
			}
			
			while( ( rcpt = this.INNER_BUFFERED_BIN.popupNoWait() ) != null ){
				this.INNER_BUFFERED_BIN.log( " add rcpt....");
				this.RCPT_TO.push( rcpt );
			}

			try {
				this.toDo();
			}
			catch (Throwable error) {
				this.INNER_BUFFERED_BIN.log( getName() + "==> is catch Throwable : " + error.toString() );
				log.error("error", error);
				if( error instanceof ThreadDeath ){
					this.alive = false;
				}
			} finally {
			}
		}
		
		this.INNER_BUFFERED_BIN.log( getName() + "==> is die....");
		/**영원히 사라진다.
		 */
		destroy();
	}
	
	protected void toDo(){
		while( this.RCPT_TO.size() > 0 ){
			this.INNER_BUFFERED_BIN.log( "RESULT|".concat( getName() ).concat( "|" ).concat( this.RCPT_TO.pop().toString() ));
		}
		
		try{
			Thread.currentThread().sleep( 1000 );
		}
		catch( Exception e ){
			log.error(e.getMessage());
		}
	}
}
