/*
 * RecycleBin.java
 *
 * Created on 2003년 10월 28일 (화), 오후 1:53
 */

package pluto.util.recycle;

import pluto.log.LogChannel;

/**
 *
 * @author  Administrator
 */
public interface RecycleBin {
	/**내부에서 일어나는 일들을 적어줄 Logger를 지정한다.
	 */
	public void setLogger( LogChannel logger );
	
	/**로깅한다.
	 */
	public  void log( String log );
	
	/**저장된 재활용품을 반환한다.
	 */
	public Recycleable getRecycleable() throws Exception;
	
	/**통 사이즈를 반환한다.
	 */
	public int getSize();
	
	/**통 사이즈를 재조정한다.
	 */
	public void reSize( int size );
	
	/**재활용 통에 넣는다.
	 */
	public void recycle( Recycleable src );
	
	/**재활용하지않고 그냥 버려버린다.
	 */
	public void destroy( Recycleable src );
}
