/*
 * StandardAgentPool.java
 *
 * Created on 2003년 3월 12일 수, 오후 5:23
 */

package pluto.util.recycle;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.Name;
import pluto.log.LogChannel;
import pluto.util.FIFOBuffer;
import pluto.util.StringConvertUtil;
/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public abstract class ObjectPool extends Name implements RecycleBin {
	
	
	protected FIFOBuffer STACK_OF_BUFFERED_OBJECT = null;
	
	protected int CAPACITY;
	
	protected int CREATE_LEVEL = 0;
	
	protected int NAME_INDEX = 0;
	
	protected Object LOCK_OF_GET = new Object();
	
	protected LogChannel LOG_CHANNEL_INSTANCE = null;
	
	/**자체 로깅이 있을 경우
	 */
	/** Creates new StandardAgentPool */
	protected ObjectPool() {
		this( 10 );
	}
	
	protected ObjectPool( int cap ) {
		super();
		this.CAPACITY = cap;
		this.STACK_OF_BUFFERED_OBJECT = new FIFOBuffer( cap );
	}
	
	public void setLogger( LogChannel logger ){
		this.LOG_CHANNEL_INSTANCE = logger;
	}
	
	public Recycleable getRecycleable() throws Exception {
		Object returnValue = null;
		while( true ) {
			if (log.isDebugEnabled()) {
				log.debug("Check IN");
			}
			/**비어 있을 경우 계속해서 기다리는지 아니면 그냥 null을 보내는지 결정한다.
			 */
			if( ( returnValue = this.STACK_OF_BUFFERED_OBJECT.pop() ) != null ) {
				Recycleable r = ( Recycleable )returnValue;
				if (log.isDebugEnabled()) {
					log.debug("Pool pop up : " + r.getName() );
				}
				return r;
			}
			
			if (log.isDebugEnabled()) {
				log.debug("NO RECYCLE  level:" + this.CREATE_LEVEL + " size:" + this.STACK_OF_BUFFERED_OBJECT.size() + "  capa " + this.CAPACITY);
			}
			
			if ( this.CREATE_LEVEL < this.CAPACITY ) {
				if (log.isDebugEnabled()) {
					log.debug("TRY CREATE ACTOR");
				}
				try{
					Recycleable worker  = create( this.CREATE_LEVEL , NAME_INDEX );
					log(worker.getName() + " is create and return =>level:".concat( String.valueOf( this.CREATE_LEVEL ) ) );
					this.CREATE_LEVEL++;NAME_INDEX++;
					return worker;
				}
				catch( Throwable thw ){
					log( StringConvertUtil.exToString( thw ) );
					if( thw instanceof Exception ){
						throw ( Exception )thw;
					}

					throw new Exception( thw.toString() );
				}
			}
			
			if (log.isDebugEnabled()) {
				log.debug("INTO Wait.");
			}
			
			synchronized( LOCK_OF_GET ){
				this.LOCK_OF_GET.wait( 10000 );
			}
		}
	}
	
	public int getSize() {
		return this.CAPACITY;
	}
	
	public void reSize( int size ) {
		this.CAPACITY = size;
		this.STACK_OF_BUFFERED_OBJECT.reSize( this.CAPACITY );
		synchronized( this ) {
			this.notifyAll();
		}
	}
	
	public void recycle( Recycleable src ) {
		if (log.isDebugEnabled()) {
			log.debug( src.getName()+ " size:" + this.STACK_OF_BUFFERED_OBJECT.size() + "  capa " + this.CAPACITY );
		}
		
		if( this.STACK_OF_BUFFERED_OBJECT.contains( src ) ){
			if (log.isDebugEnabled()) {
				log.debug( src.getName()+ " is already in pool" );
			}
			return;
		}
		
		if( this.STACK_OF_BUFFERED_OBJECT.push( src ) ) {
			if (log.isDebugEnabled()) {
				log.debug( src.getName()+ " is recycled" );
			}
			synchronized( LOCK_OF_GET ){
				this.LOCK_OF_GET.notifyAll();
			}
		}
		else {
			if (log.isDebugEnabled()) {
				log.debug("No Room for " + src.getName() );
			}
			src.setEnd();
		}
	}
	
	public void destroy( Recycleable src ) {
		if (log.isDebugEnabled()) {
			log.debug( src.getName() + " is remove");
		}
		this.CREATE_LEVEL--;
		this.STACK_OF_BUFFERED_OBJECT.remove( src );
	}
	
	protected abstract Recycleable create( int seq , int level ) throws Exception;
}
