package pluto.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsFileReader;
import pluto.io.eMsFileWriter;

@Slf4j
public class eMsProperties extends Properties {
	/**
	 * 
	 */
	private static final long serialVersionUID = 573073693526452524L;
	public eMsProperties() {
		this(null);
	}
	
	/**
	 * Creates an empty property list with the specified defaults.
	 *
	 * @param   defaults   the defaults.
	 */
	public eMsProperties(Properties defaults) {
		super( defaults );
	}
	
	public synchronized void load(InputStream inStream) throws IOException {
		eMsFileReader in = new eMsFileReader( inStream );
		while (true) {
			// Get next line
			String line = in.readLine();
			if (line == null)
				break;
			
			if( line.length() < 1 ) continue;
			
			// Continue lines that end in slashes if they are not comments
			char firstChar = line.charAt(0);
			
			if((firstChar == '#') || (firstChar == '!')) continue;
			
			while (iscontinueLine(line)) {
				String nextLine = in.readLine();
				if(nextLine == null) {
					nextLine = new String("");
				}
				
				String loppedLine = line.substring(0, line.length()-1);
				
				line = loppedLine.concat( "\r\n" ).concat( nextLine );
			}
			
			int idx = line.indexOf("=");
			
			if( idx < 0 ) continue;
			
			// Convert then store key and value
			String key = line.substring( 0 , idx );
			String value = line.substring( idx + 1 );
			put(key, value);
		}
		
		try{ in.close(); }catch( Exception e){}
		try{ inStream.close(); }catch( Exception e){}
	}
	
	/*
	 * Returns true if the given line is a line that must
	 * be appended to the next line
	 */
	private boolean iscontinueLine(String line) {
		if( line == null ) return false;
		return line.endsWith("\\");
	}
	
	public synchronized void store(OutputStream out, String header) throws IOException {
		eMsFileWriter awriter  = new eMsFileWriter( out );
		if (header != null) {
			awriter.println( "#" + header );
		}
		
		awriter.println( "#" + new Date().toString());
		
		for (Enumeration e = keys(); e.hasMoreElements();) {
			String key = (String)e.nextElement();
			String val = (String)get(key);
			
			awriter.write( key );
			awriter.write( "=" );
			awriter.println( ConvertSave( val ) );
		}
		awriter.flush();
		try{ awriter.close(); }catch( Exception e){}
		try{ out.close(); }catch( Exception e){}
	}
	/*
	 * Converts unicodes to encoded &#92;uxxxx
	 * and writes out any of the characters in specialSaveChars
	 * with a preceding slash
	 */
	private String ConvertSave( String theString ) throws IOException {
		if( theString == null || theString.length() < 1 ) return "";
		
		StringBuffer buffer = null;
		try{
			buffer = new StringBuffer(128);
			BufferedReader tmpReader = new BufferedReader( new StringReader( theString ) );
			
			String read_line = tmpReader.readLine();
			
			if( read_line == null ) return "";
			
			buffer.append( read_line );
			
			while( tmpReader.ready() ) {
				read_line = tmpReader.readLine();
				
				if( read_line == null ) break;
				
				buffer.append( "\\\r\n" );
				buffer.append( read_line );
			}
			
			return buffer.toString();
		}
		catch( IOException e ){
			throw e;
		}
		finally{
			buffer = null;
		}
	}
}
