/*
 * @(#).java            2004. 12. 17.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package pluto.util.convert;

import java.util.Map;
/**
 * Class description :
 * 
 * @version		
 * @author 		lena
 *
 */
public class StringConvert {
	
	/** 원본의 특정 스트링을 치환한다. target -> dest
	 * @param WORK_BUFFER 변환된 String을 저장할 Buffer
	 * @param source 원본스트링
	 * @param target 치환될 대상 스트링
	 * @param dest 치환될 스트링
	 */
	public static final void ConvertString( StringBuffer WORK_BUFFER, String source, String target, String dest ) {
		if( source == null ) return;

		int idx1 = 0;
		int idx2 = 0;
		
		while( true ) {
			idx1 = source.indexOf( target , idx2 );
			
			if( idx1 < 0 ) break;
			
			WORK_BUFFER.append( source.substring( idx2 , idx1 ) );
			WORK_BUFFER.append( dest );
			
			idx2 = idx1 + target.length();
		}
		
		WORK_BUFFER.append( source.substring( idx2) );
	}
	
	public static final void ConvertStringUseMap(StringBuffer WORK_BUFFER, Map map,String start,String end , boolean convert_empty , boolean query ) {
		String src = WORK_BUFFER.toString();
		WORK_BUFFER.setLength( 0 );
		ConvertStringUseMap( WORK_BUFFER , src , map , start , end , convert_empty , query );
	}
	/** ConvertString과 동일하지만 만일 키가 존재하지 않을 경우에는 해당 index를 치환하지 않고 그대로 유지한다.
	 * @param WORK_BUFFER 변환된 String을 저장할 Buffer
	 * @param src 원본 스트링
	 * @param map 매핑 ( Map )
	 * @param start 인덱스 prefix
	 * @param end 인덱스 sufix
	 * @param convert_empty true:키가 존재하지 않으면 치환하지 않음 / false : 키가 없으면 공백으로 치환
	 * @param query true:매핑시 " ' " 를 " '' " 로 치환 / false : 치환없음
	 */
	public static final void ConvertStringUseMap(StringBuffer WORK_BUFFER, String src,Map map,String start,String end , boolean convert_empty , boolean query ) {
		if( src == null || map == null || WORK_BUFFER == null ) return;
		
		int idx1 = 0 ;
		int idx2 = 0;
		int idx3 = 0;
		
		String key = null;
		Object value = null;
		
		while(true) {
			idx1 = src.indexOf(start,idx3);
			if( idx1 < 0 ) break;
			
			idx2 = src.indexOf(end,idx1 + start.length());
			if( idx2 < 0 ) break;
			
			key = src.substring( idx1 + start.length() , idx2 );
			value = map.get( key );
			
			WORK_BUFFER.append( src.substring(idx3,idx1) );
			
			if( value != null ) {
				if( query ){
					ConvertString( WORK_BUFFER , value.toString() , "'" , "''" );
				}
				else{
					WORK_BUFFER.append( value.toString() );
				}
			}
			else if( convert_empty ){
				WORK_BUFFER.append( start );
				WORK_BUFFER.append( key );
				WORK_BUFFER.append( end );
			}
			
			idx3 = idx2 + end.length();
		}
		
		WORK_BUFFER.append( src.substring(idx3) );
		
		return;
	}
}
