package pluto.util.convert;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SHA256 {

	public static String encode(String planText){
		 MessageDigest digest;
		 StringBuffer hexString = new StringBuffer();
		try {
			digest = MessageDigest.getInstance("SHA-256");
			byte[] hash;
			hash = digest.digest(planText.getBytes("UTF-8"));
	       
			for (int i = 0; i < hash.length; i++) {
	             String hex = Integer.toHexString(0xff & hash[i]);
	             if(hex.length() == 1) hexString.append('0');
	             hexString.append(hex);
	         }
		} catch (NoSuchAlgorithmException e) {
			log.error("NoSuchAlgorithmException",e);
		} catch (UnsupportedEncodingException e) {
			log.error("UnsupportedEncodingException",e);
		}
         
         
         
        return hexString.toString();
	}
}
