/*
 * Created on 2005. 10. 22.
 */
package pluto.util.convert;

import java.io.OutputStream;

import lombok.extern.slf4j.Slf4j;
import pluto.io.BASE64EncodeOutputStream;
import pluto.io.QPEncodeOutputStream;
import pluto.io.UUEncodeOutputStream;
import pluto.io.eMsByteArrayOutputStream;
import pluto.lang.eMsTypes;
import pluto.util.EmsLock;

/**
 * @author 이상근
 */
@Slf4j
public class MimeConvertor {
	

	public static final int			ENCODE_SUBJECT_HEADER_SPLIT_LIMIT	= 15;

	public static final int			NORMAL_SUBJECT_HEADER_SPLIT_LIMIT	= 30;

	private static final String		JIS_CONVERT							= " SJIS ISO-2022-JP ";

	private static final byte[]		JIS_ESC								= {
			0x1B, 0x28, 0x42, 0x1B, 0x24, 0x42, 0x1B, 0x28, 0x49		};

	public static final String getMimeText(String src, String baseCharset, String mimeCharset, short type, boolean header) throws Exception {
		eMsByteArrayOutputStream out = null;

		try {
			out = eMsByteArrayOutputStream.getInstance();
			if( header ) {
				putHeaderToStream(out, src, baseCharset, mimeCharset, type);
			}
			else {
				putMimeToStream(out, src, baseCharset, mimeCharset, type);
			}
			return out.toString(mimeCharset);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			eMsByteArrayOutputStream.recycleInstance(out);
		}

	}

	public static final void putMimeToStream(OutputStream out, String src, String baseCharset, String mimeCharset, short type) throws Exception {
		OutputStream ENC_STREAM = null;
		// HEAD
		switch (type) {
			case eMsTypes.ENC_BASE64: {
				//ENC_STREAM = new BASE64EncodeOutputStream(out, 1024);
				//BASE64 인코딩시 옆으로 길어지는 것 방지
				ENC_STREAM = new BASE64EncodeOutputStream(out);
				break;
			}
			case eMsTypes.ENC_QP: {
				ENC_STREAM = new QPEncodeOutputStream(out, 1024);
				break;
			}

			case eMsTypes.ENC_UUENCODE: {
				ENC_STREAM = new UUEncodeOutputStream(out);
				break;
			}
			default: {
				ENC_STREAM = out;
			}
		}

		// echo BODY : EMSJapan
		/*
		if( mimeCharset != null && JIS_CONVERT.indexOf(mimeCharset.toUpperCase()) > 0 ) {
			if (log.isDebugEnabled()) {
				log.debug("convert jis:" + src);
			}
			sjis2jis(src.getBytes(mimeCharset), ENC_STREAM);
		}
		else {
			if (log.isDebugEnabled()) {
				log.debug("normal split");
			}
			ENC_STREAM.write(src.getBytes(mimeCharset));
		}
		*/

		ENC_STREAM.write(src.getBytes(mimeCharset));
		ENC_STREAM.flush();

		out.flush();
	}

	private static final int	EQUAL		= '=';

	private static final int	QUESTION	= '?';

	private static final int	BASE64_OUT	= 'B';

	private static final int	QP_OUT		= 'Q';

	public static final void putHeaderToStream(OutputStream out, String src, String baseCharset, String mimeCharset, short type) throws Exception {
		OutputStream ENC_STREAM = null;
		// HEAD
		switch (type) {
			case eMsTypes.ENC_BASE64: {
				out.write(EQUAL);
				out.write(QUESTION);
				out.write(mimeCharset.getBytes());
				out.write(QUESTION);
				out.write(BASE64_OUT);
				out.write(QUESTION);
				ENC_STREAM = new BASE64EncodeOutputStream(out, 1024);
				break;
			}
			case eMsTypes.ENC_QP: {
				out.write(EQUAL);
				out.write(QUESTION);
				out.write(mimeCharset.getBytes());
				out.write(QUESTION);
				out.write(QP_OUT);
				out.write(QUESTION);
				ENC_STREAM = new QPEncodeOutputStream(out, 1024);
				break;
			}

			default: {
				ENC_STREAM = out;
			}
		}

		// echo BODY
		if( JIS_CONVERT.indexOf(mimeCharset.toUpperCase()) > 0 ) {
			if (log.isDebugEnabled()) {
				log.debug("convert jis:" + src);
			}
			sjis2jis(src.getBytes(baseCharset), ENC_STREAM);
		}
		else {
			if (log.isDebugEnabled()) {
				log.debug("normal split");
			}
			ENC_STREAM.write(src.getBytes(baseCharset));
		}

		ENC_STREAM.flush();

		switch (type) {
			case eMsTypes.ENC_BASE64:
			case eMsTypes.ENC_QP: {
				out.write(QUESTION);
				out.write(EQUAL);
			}

			default: {

			}
		}

		out.flush();
	}

	public static final void putSubjectToStream(OutputStream out, String src, String baseCharset, String mimeCharset, boolean encode) throws Exception {
		int limit = encode ? ENCODE_SUBJECT_HEADER_SPLIT_LIMIT : NORMAL_SUBJECT_HEADER_SPLIT_LIMIT;
		int length = src.length();
		if( length > limit ) {
			int idx = 0;
			while (idx < length) {
				String target = (idx + limit) < length ? src.substring(idx, idx + limit) : src.substring(idx);
				if( idx > 0 ) {
					out.write("\r\n ".getBytes());
				}
				MimeConvertor.putHeaderToStream(out, target, baseCharset, mimeCharset, encode ? eMsTypes.ENC_BASE64 : eMsTypes.ENC_8BIT);
				idx += limit;
			}
		}
		else {
			MimeConvertor.putHeaderToStream(out, src, baseCharset, mimeCharset, encode ? eMsTypes.ENC_BASE64 : eMsTypes.ENC_8BIT);
		}
	}

	public static void sjis2jis(byte[] b, OutputStream out) throws Exception {
		int b2 = 0;
		int c = 0;
		int n = b.length;

		for (int i = 0; i < n; i++) {
			int b1 = (b[i] < 0 ? b[i] + 256 : b[i]);

			if( 0xA1 <= b1 && b1 <= 0xDF ) {
				if( c != 2 ) {
					c = 2;
					if (log.isDebugEnabled()) {
						System.out.print("/");
					}
					out.write(JIS_ESC[6]);
					out.write(JIS_ESC[8]);
					out.write(JIS_ESC[8]);
				}
				out.write(b1);
			}
			else if( b1 >= 0x80 ) {
				if( c != 1 ) {
					c = 1;
					if (log.isDebugEnabled()) {
						System.out.print("-");
					}
					out.write(JIS_ESC[3]);
					out.write(JIS_ESC[4]);
					out.write(JIS_ESC[5]);
				}

				b2 = b[i + 1] < 0 ? b[i + 1] + 256 : b[i + 1];
				b1 <<= 1;
				if( b2 < 0x9F ) {
					if( b1 < 0x13F ) {
						b1 -= 0xE1;
					}
					else {
						b1 -= 0x61;
					}

					if( b2 > 0x7E ) {
						b2 -= 0x20;
					}
					else {
						b2 -= 0x1F;
					}
				}
				else {
					if( b1 < 0x13F )
						b1 -= 0xE0;
					else
						b1 -= 0x60;
					b2 -= 0x7E;
				}
				out.write(b1);
				out.write(b2);
				i++;
			}
			else {
				if( c != 0 ) {
					c = 0;
					if (log.isDebugEnabled()) {
						System.out.print("\\");
					}
					out.write(JIS_ESC[0]);
					out.write(JIS_ESC[1]);
					out.write(JIS_ESC[2]);
				}
				out.write(b1);
			}
		}
		if( c != 0 ) {
			if (log.isDebugEnabled()) {
				System.out.print("*");
			}
			out.write(JIS_ESC[0]);
			out.write(JIS_ESC[1]);
			out.write(JIS_ESC[2]);
		}
	}
}
