/*
 * HtmlTableFilter.java
 *
 * Created on 2002년 11월 16일 토, 오후 2:58
 */

package pluto.util.convert;

/**
 *
 * @author  Administrator
 * @version
 */

/** 만든취지는 제작물을 업로드 할때나 템플릿 제작후에 복잡한 구조의 테이블 테그들의 인덴트를 맞춤으로서 제작물 변형을
 * 미연에 방지함이다.
 *파싱룰 1 : INDEX_PLUS 에 정의된 테그들이 나오면 인덴트를 추가하고 INDEX_MINUS 테그들이 나오면 인덴트를 감소시킨다.
 *파싱룰 2 : 템플릿에서 사용하는 테그들은 구별이 용이하도록 인덴트를 주지않는다.
 *파싱룰 3 : 테그들의 Property 구분자를 정리한다.
 *파싱룰 4 : 테그 중간에 삽입된 개행문자를 제거하여 가독성을 높인다.
 */
public class HtmlTableFilter {
	/**인덴트를 추가하는 테그들
	 */
	protected static final String[] INDEX_PLUS = { "<table" , "<tr" , "<td" , "<body"};
	
	/** 인덴트를 감소시키는 테그들
	 */
	protected static final String[] INDEX_MINUS = { "</table","</tr","</td" , "</body"};
	
	/**템플릿에서 추가적으로 사용하는 테그들
	 */
	protected static final String[] INDEX_NO_INDENT = {"<if" , "<list" , "</if" , "</list" , "<comment" , "<compress" , "</compress"};
	
	/** 테그 시작 한정자
	 */
	public static final String Start = "<";
	
	/** 테그 시작 한정자의 길이
	 */
	public static final int len_Start = Start.length();
	/** 테그종료 한정자
	 */
	public static final String End = ">";
	
	/** 테그종료 한정자 길이
	 */
	public static final int len_End = End.length();
	
	/** 인덴트를 기록
	 */
	private int indent_idx = 0;
	
	/** 파싱을 하는 원본을 보관한다.
	 */
	private String original = null;
	
	/** 인덱스를 찾기 위해서 원본을 소문자로 전환한 내용을 저장
	 */
	private String convert = null;
	
	/** 테이블 구성 테그중에서 시작 테그를 저장
	 */
	private String open_tag = null;
	
	/** 테이블 구성 테그중에서 종료 테그를 저장
	 */
	private String close_tag = null;
	
	/** Creates new HtmlTableFilter */
	public HtmlTableFilter(String src) {
		this.original = src;
		this.convert = src.toLowerCase();
	}
	
	/** 입력된 내용을 파싱
	 * @return 파싱결과
	 */
	public String parse() {
		StringBuffer tmpBuffer = new StringBuffer();
		
		int idx1 = 0;
		int idx2 = 0;
		this.indent_idx = 0;
		
		while( true ) {
			idx1 = this.convert.indexOf( Start , idx2 );
			
			if( idx1 < 0 ) break;
			
			tmpBuffer.append( this.original.substring( idx2 , idx1 ).trim() );
			
			idx2 = this.convert.indexOf( End , idx1 + len_Start );
			
			if( idx2 < 0 ) break;
			
			idx2 += len_End;
			
			String tag = this.convert.substring( idx1 , idx2 );
			
			if( isPlus( tag ) ) {
				tmpBuffer.append("\r\n");
				for( int i = 0 ; i < this.indent_idx ; i++ ) {
					tmpBuffer.append("\t");
				}
				this.indent_idx++;
			}
			else if( isMinus( tag ) ) {
				this.indent_idx--;
				
				if( this.open_tag.equals("<td") && this.close_tag.equals("</td") ) {
				}
				else {
					tmpBuffer.append("\r\n");
					for( int i = 0 ; i < this.indent_idx ; i++ ) {
						tmpBuffer.append("\t");
					}
				}
				
				this.open_tag = "none";
			}
			else if( isIndent( tag ) ) {
				tmpBuffer.append("\r\n");
			}
			else {
				tmpBuffer.append("\r\n");
				for( int i = 0 ; i < this.indent_idx ; i++ ) {
					tmpBuffer.append("\t");
				}
			}
			
			tmpBuffer.append( this.original.substring( idx1 , idx2 ) );
		}
		
		if( idx1 < 0 ) {
			tmpBuffer.append( this.original.substring( idx2 ) );
		}
		else {
			tmpBuffer.append( this.original.substring( idx1 ) );
		}
		
		return tmpBuffer.toString();
	}
	
	private boolean isPlus( String src ) {
		if( src == null ) return false;
		
		for( int i = 0 ; i < INDEX_PLUS.length ; i++ ) {
			if( src.startsWith( INDEX_PLUS[i] ) ) {
				this.open_tag = INDEX_PLUS[i];
				return true;
			}
		}
		
		return false;
	}
	
	private boolean isMinus( String src ) {
		if( src == null ) return false;
		
		for( int i = 0 ; i < INDEX_MINUS.length ; i++ ) {
			if( src.startsWith( INDEX_MINUS[i] ) ) {
				this.close_tag = INDEX_MINUS[i];
				return true;
			}
		}
		
		return false;
	}
	
	private boolean isIndent( String src ) {
		if( src == null ) return false;
		
		for( int i = 0 ; i < INDEX_NO_INDENT.length ; i++ ) {
			if( src.startsWith( INDEX_NO_INDENT[i] ) ) {
				return true;
			}
		}
		
		return false;
	}
}
