/*
 * DelimFilter.java
 *
 * Created on 2002년 6월 12일 수, 오전 9:07
 */

package pluto.util.convert;

/**
 * 
 * @author dragon
 * @version
 */
import java.util.Hashtable;

import lombok.extern.slf4j.Slf4j;
import pluto.util.StringConvertUtil;

@Slf4j
public class DelimConvertor {
	

	public static final String			ENC_CHARS	= "\r\n|[]{}";

	protected static String[]			ENC_TARGETS	= null;

	protected static Hashtable			DEC_MAP		= new Hashtable();

	static {
		ENC_TARGETS = new String[7];
		ENC_TARGETS[0] = "$#CR#";
		ENC_TARGETS[1] = "$#LF#";
		ENC_TARGETS[2] = "$#delim#";
		ENC_TARGETS[3] = "$#start_big#";
		ENC_TARGETS[4] = "$#end_big#";
		ENC_TARGETS[5] = "$#start_small#";
		ENC_TARGETS[6] = "$#end_small#";
		/**
		 * ENC_MAP.put("\r","$#CR#"); ENC_MAP.put("\n","$#LF#");
		 * ENC_MAP.put("|","$#delim#"); ENC_MAP.put("[","$#start_big#");
		 * ENC_MAP.put("]","$#end_big#"); ENC_MAP.put("{","$#start_small#");
		 * ENC_MAP.put("}","$#end_small#"); DEC_MAP.put("$#delim#","|");
		 * DEC_MAP.put("$#start_big#","["); DEC_MAP.put("$#end_big#","]");
		 * DEC_MAP.put("$#start_small#","{"); DEC_MAP.put("$#end_small#","}");
		 * DEC_MAP.put("$#CR#","\r"); DEC_MAP.put("$#LF#","\n");
		 */
		DEC_MAP.put("delim", "|");
		DEC_MAP.put("start_big", "[");
		DEC_MAP.put("end_big", "]");
		DEC_MAP.put("start_small", "{");
		DEC_MAP.put("end_small", "}");
		DEC_MAP.put("CR", "\r");
		DEC_MAP.put("LF", "\n");
	}

	/**
	 * 버퍼의 재사용상의 문제로 사용하지 않음. public static String encode( String returnValue ) {
	 * if( returnValue == null ) return ""; eMsStringBuffer __TMP_BUFFER__ =
	 * null; try{ __TMP_BUFFER__ = eMsStringBuffer.getInstance();
	 * __TMP_BUFFER__.setLength(0);
	 * 
	 * encodeToBuffer( __TMP_BUFFER__ , returnValue );
	 * 
	 * return __TMP_BUFFER__.toString(); } catch( RuntimeException e ){ throw e; }
	 * finally{ eMsStringBuffer.recycleInstance( __TMP_BUFFER__ ); } }
	 */

	public static void encodeToBuffer(StringBuffer __TMP_BUFFER__, String returnValue) {
		if( returnValue == null )
			return;
		if (log.isDebugEnabled()) 
			log.debug("DELIM ENCODE BEFORE", returnValue);
		int enc_index = -1;
		char target_charactor = '\0';

		int length = returnValue.length();
		for (int idx = 0; idx < length; idx++) {
			target_charactor = returnValue.charAt(idx);
			enc_index = ENC_CHARS.indexOf(target_charactor);
			if( enc_index < 0 ) {
				__TMP_BUFFER__.append(target_charactor);
			}
			else {
				__TMP_BUFFER__.append(ENC_TARGETS[enc_index]);
			}
		}
	}

	public static String encode(String returnValue) {
		if( returnValue == null )
			return null;
		if (log.isDebugEnabled()) 
			log.debug("DELIM ENCODE BEFORE", returnValue);
		int enc_index = -1;
		char target_charactor = '\0';

		int length = returnValue.length();
		StringBuffer __TMP_BUFFER__ = new StringBuffer();
		for (int idx = 0; idx < length; idx++) {
			target_charactor = returnValue.charAt(idx);
			enc_index = ENC_CHARS.indexOf(target_charactor);
			if( enc_index < 0 ) {
				__TMP_BUFFER__.append(target_charactor);
			}
			else {
				__TMP_BUFFER__.append(ENC_TARGETS[enc_index]);
			}
		}
		return __TMP_BUFFER__.toString();
	}

	public static String decode(String source) {
		if( source == null )
			return "";

		StringBuffer __TMP_BUFFER__ = null;

		try {
			__TMP_BUFFER__ = new StringBuffer(256);
			__TMP_BUFFER__.setLength(0);

			decodeToBuffer(__TMP_BUFFER__, source);

			return __TMP_BUFFER__.toString();
		}
		catch(RuntimeException e) {
			throw e;
		}
		finally {
			__TMP_BUFFER__ = null;
		}
	}

	public static void decodeToBuffer(StringBuffer __TMP_BUFFER__, String source) {
		if( source == null )
			return;

		StringConvertUtil.ConvertString(__TMP_BUFFER__, source, DEC_MAP, "$#", "#", false, false);
	}
}
