/*
 * BASE64.java
 *
 * Created on 2001년 6월 25일 월, 오후 4:55
 */

package pluto.util.convert;

/**
 * 
 * @author Administrator
 * @version
 */
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;

//import pluto.io.*;

@Slf4j
public class BASE64 {
	public static final boolean	DEBUG		= false;

	private static final char	BaseTable[]	= {
			'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a',
			'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1',
			'2', '3', '4', '5', '6', '7', '8', '9', '+', '/' };

	private static final byte	ConvertBaseTable[];

	static {
		ConvertBaseTable = new byte[256];
		for (int i = 0; i < 255; i++) {
			ConvertBaseTable[i] = -1;
		}

		for (int j = 0; j < BaseTable.length; j++) {
			ConvertBaseTable[BaseTable[j]] = (byte) j;
		}

	}

	public synchronized static String encode(String src) {
		if( src.length() == 0 ) {
			return src;
		}

		byte[] source = null; 
		try {
			source = src.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			source = src.getBytes();
		}

		return new String(encode_base(source));
	}

	public static String encode(byte[] source) {
		return new String(encode_base(source));
	}

	public static void encode_sep(byte[] __SOURCE__, int __LENGTH__, byte[] __TARGET__) {
		__LENGTH__ = __LENGTH__ > 3 ? 3 : __LENGTH__;

		switch (__LENGTH__) {
			case 1: {
				__TARGET__[0] = (byte) BaseTable[__SOURCE__[0] >>> 2 & 0x3f];
				__TARGET__[1] = (byte) BaseTable[(__SOURCE__[0] << 4 & 0x30) + (0 >>> 4 & 0xf)];
				__TARGET__[2] = 61;
				__TARGET__[3] = 61;
				break;
			}
			case 2: {
				__TARGET__[0] = (byte) BaseTable[__SOURCE__[0] >>> 2 & 0x3f];
				__TARGET__[1] = (byte) BaseTable[(__SOURCE__[0] << 4 & 0x30) + (__SOURCE__[1] >>> 4 & 0xf)];
				__TARGET__[2] = (byte) BaseTable[(__SOURCE__[1] << 2 & 0x3c) + (0 >>> 6 & 0x3)];
				__TARGET__[3] = 61;
				break;
			}
			case 3: {
				__TARGET__[0] = (byte) BaseTable[__SOURCE__[0] >>> 2 & 0x3f];
				__TARGET__[1] = (byte) BaseTable[(__SOURCE__[0] << 4 & 0x30) + (__SOURCE__[1] >>> 4 & 0xf)];
				__TARGET__[2] = (byte) BaseTable[(__SOURCE__[1] << 2 & 0x3c) + (__SOURCE__[2] >>> 6 & 0x3)];
				__TARGET__[3] = (byte) BaseTable[__SOURCE__[2] & 0x3f];
				break;
			}
		}
	}

	public static byte[] encode_base(byte[] source) {
		if( source == null || source.length == 0 ) {
			return source;
		}

		byte target[] = new byte[((source.length + 2) / 3) * 4];
		int i = 0;
		int j = 0;
		for (int k = source.length; k > 0; k -= 3) {
			if( k == 1 ) {
				byte byte0 = source[i++];
				int l = 0;
				// boolean flag = false;
				target[j++] = (byte) BaseTable[byte0 >>> 2 & 0x3f];
				target[j++] = (byte) BaseTable[(byte0 << 4 & 0x30) + (l >>> 4 & 0xf)];
				target[j++] = 61;
				target[j++] = 61;
			}
			else {
				if( k == 2 ) {
					byte byte1 = source[i++];
					byte byte3 = source[i++];
					int i1 = 0;
					target[j++] = (byte) BaseTable[byte1 >>> 2 & 0x3f];
					target[j++] = (byte) BaseTable[(byte1 << 4 & 0x30) + (byte3 >>> 4 & 0xf)];
					target[j++] = (byte) BaseTable[(byte3 << 2 & 0x3c) + (i1 >>> 6 & 0x3)];
					target[j++] = 61;
				}
				else {
					byte byte2 = source[i++];
					byte byte4 = source[i++];
					byte byte5 = source[i++];
					target[j++] = (byte) BaseTable[byte2 >>> 2 & 0x3f];
					target[j++] = (byte) BaseTable[(byte2 << 4 & 0x30) + (byte4 >>> 4 & 0xf)];
					target[j++] = (byte) BaseTable[(byte4 << 2 & 0x3c) + (byte5 >>> 6 & 0x3)];
					target[j++] = (byte) BaseTable[byte5 & 0x3f];
				}
			}
		}

		return target;
	}

	public synchronized static String decode(String src) {
		if( src == null || src.length() == 0 ) {
			return "";
		}

		return decode(src.getBytes());
	}

	public static String decode(byte[] src) {
		return decode(src, eMsLocale.CHAR_SET);
	}

	public static String decode(byte[] src, String charset) {
		try {
			return new String(decode_base(src), charset);
		}
		catch(Exception e) {
			return new String(decode_base(src));
		}
	}

	public static int decode_sep(byte[] __SOURCE__, byte[] __TARGET__) {
		if( __SOURCE__.length != 4 )
			throw new RuntimeException("INVAILD SIZE");

		byte L1 = 0;
		byte L2 = 0;

		byte byte0 = ConvertBaseTable[__SOURCE__[0] & 0xff];
		byte byte1 = ConvertBaseTable[__SOURCE__[1] & 0xff];
		L1 = (byte) (byte0 << 2 & 0xfc | byte1 >>> 4 & 0x3);
		if( __SOURCE__[2] == 61 ) {
			__TARGET__[0] = L1;
			return 1;
		}

		byte0 = byte1;
		byte1 = ConvertBaseTable[__SOURCE__[2] & 0xff];
		L2 = (byte) (byte0 << 4 & 0xf0 | byte1 >>> 2 & 0xf);
		if( __SOURCE__[3] == 61 ) {
			__TARGET__[0] = L1;
			__TARGET__[1] = L2;
			return 2;
		}

		__TARGET__[0] = L1;
		__TARGET__[1] = L2;

		byte0 = byte1;
		byte1 = ConvertBaseTable[__SOURCE__[3] & 0xff];
		__TARGET__[2] = (byte) (byte0 << 6 & 0xc0 | byte1 & 0x3f);

		return 3;
	}

	public static byte[] decode_base(byte[] source) {
		if( source.length == 0 ) {
			return source;
		}

		ByteArrayOutputStream out = new ByteArrayOutputStream(source.length);

		int j = 0;
		// int k = 0;
		while (j < source.length) {
			if( source[j] == 0 ) {
				break;
			}

			byte byte0 = ConvertBaseTable[source[j++] & 0xff];

			
			byte byte1 = ConvertBaseTable[source[j++] & 0xff];
			out.write((byte0 << 2 & 0xfc | byte1 >>> 4 & 0x3));
			if( source[j] == 61 ) {
				break;
			}

			byte0 = byte1;
			byte1 = ConvertBaseTable[source[j++] & 0xff];
			out.write(byte0 << 4 & 0xf0 | byte1 >>> 2 & 0xf);
			if( source[j] == 61 ) {
				break;
			}
			byte0 = byte1;
			byte1 = ConvertBaseTable[source[j++] & 0xff];
			out.write(byte0 << 6 & 0xc0 | byte1 & 0x3f);
		}

		byte[] returnValue = out.toByteArray();

		return returnValue;
	}

	private static final byte	BLANK	= (byte) ' ';

	private static final byte	TAB		= (byte) '\t';

	private static final byte	CR		= (byte) '\r';

	private static final byte	LF		= (byte) '\n';

	public static void decodeToStream(byte[] source, OutputStream out) throws Exception {
		if( source == null || source.length == 0 ) {
			return;
		}

		int j = 0;
		// int k = 0;
		while (j < source.length) {
			if( source[j] == 0 ) {
				break;
			}

			for (; source[j] == BLANK || source[j] == TAB || source[j] == CR || source[j] == LF; j++) {
				// empty
			}

			byte byte0 = ConvertBaseTable[source[j++] & 0xff];
			byte byte1 = ConvertBaseTable[source[j++] & 0xff];
			out.write((byte0 << 2 & 0xfc | byte1 >>> 4 & 0x3));
			if( source[j] == 61 ) {
				break;
			}

			byte0 = byte1;
			byte1 = ConvertBaseTable[source[j++] & 0xff];
			out.write(byte0 << 4 & 0xf0 | byte1 >>> 2 & 0xf);
			if( source[j] == 61 ) {
				break;
			}
			byte0 = byte1;
			byte1 = ConvertBaseTable[source[j++] & 0xff];
			out.write(byte0 << 6 & 0xc0 | byte1 & 0x3f);
		}

		return;
	}
	
	
	public static void main(String[] args) {
		String s = "TV9JRD1pZDU=&U1RZUEU9Q0FNUA==&TElTVF9UQUJMRT1UTVNfRU1BSUxfTElTVF8wNw==&UE9TVF9JRD0yMDEzMDcxNzAwMDA0&U0VSVkVSX0lEPTAx&VEM9MjAxMzA3Mjk=&S0lORD1P";
		log.debug(BASE64.decode(s));
	}
}
