/*
 * SunToLunar.java
 *
 * Created on 2003년 4월 18일 금, 오후 2:54
 */

package pluto.util;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author Administrator
 * @version
 */
@Slf4j
public class SunToLunar extends java.lang.Object {
	///////////////////////////////////////////////////////////////////////////////////////////////////////////Not
	// My Work
	private int					syear, smonth, sday;																							/*
																																				    * year,
																																				    * month,
																																				    * day
																																				    */

	private int					lyear, lmonth, lday;																							/*
																																				    * calculated
																																				    * solar
																																				    * date
																																				    */

	private int					m1, m2, i, j, jcount;

	//, w, m0,k1,k2,n2, i1, j1;
	private boolean				ll;

	// leapyes,leap;
	private int					dt[]			= new int[163];

	private long				td, td0, td1, td2, k11;

	// y;

	private static final int	m[]				= {
			31, 0, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

	private static final int	kk[]			= {
			/* 1881 */1, 2, 1, 2, 1, 2, 2, 3, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 0, 1, 1, 2, 1, 1, 2, 1, 2, 2, 2, 1, 2, 0, 2, 1, 1,
			2, 1, 3, 2, 1, 2, 2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 0, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 0, 2, 2, 1, 2, 3, 2, 1, 1, 2, 1,
			2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 0, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 1, 2, 3, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2,

			/* 1891 */1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 0, 1, 1, 2, 1, 1, 2, 3, 2, 2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 0, 1, 2, 1,
			2, 1, 1, 2, 1, 2, 1, 2, 2, 0, 2, 1, 2, 1, 2, 3, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 0, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1,
			2, 1, 0, 2, 1, 2, 3, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 0, 1, 2, 1, 1, 2, 1, 2, 2, 3, 2, 2, 1, 2,

			/* 1901 */1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 0, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 0, 1, 2, 1, 2, 1, 3, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1,
			2, 1, 1, 2, 1, 1, 2, 2, 1, 0, 2, 2, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 0, 1, 2, 2, 1, 4, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1,
			2, 1, 0, 2, 1, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 0, 1, 2, 3, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 0,

			/* 1911 */2, 1, 2, 1, 1, 2, 3, 1, 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2, 0, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 0, 2, 2, 1,
			2, 2, 3, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 0, 2, 1, 3, 2, 1, 2, 2, 1, 2, 2,
			1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 0, 1, 2, 1, 1, 2, 1, 2, 3, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 0,

			/* 1921 */2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 0, 2, 1, 2, 2, 1, 3, 2, 1, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 0, 2, 1, 2,
			1, 2, 2, 1, 2, 1, 2, 1, 1, 0, 2, 1, 2, 2, 3, 2, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 0, 2, 1, 1, 2, 1, 2, 1, 2, 2, 1,
			2, 2, 0, 1, 2, 3, 1, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 2, 0, 1, 2, 2, 1, 1, 2, 3, 1, 2, 1, 2, 2, 1,

			/* 1931 */2, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 1, 0, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 0, 1, 2, 2, 1, 2, 4, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1,
			2, 2, 1, 2, 2, 1, 2, 1, 2, 0, 1, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 0, 2, 1, 1, 4, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2,
			2, 1, 0, 2, 2, 1, 1, 2, 1, 1, 4, 1, 2, 2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 1, 2, 0, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 0,

			/* 1941 */2, 2, 1, 2, 2, 1, 4, 1, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 0, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 0, 1, 1, 2,
			1, 4, 1, 2, 1, 2, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 2, 1, 2, 0, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 0, 2, 2, 3, 1, 2, 1, 1, 2, 1, 2,
			1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 0, 2, 2, 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 0,

			/* 1951 */2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 1, 2, 1, 2, 1, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 2, 1, 2, 2, 0, 1, 1, 2,
			1, 1, 2, 1, 2, 2, 1, 2, 2, 0, 2, 1, 1, 4, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 0, 2, 1, 2, 1, 2, 1, 1, 2, 3, 2,
			1, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 0, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 2, 1, 2, 1, 2, 2, 3, 2, 1, 2, 1, 2, 1,

			/* 1961 */2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 0, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 2, 1, 0, 2, 1, 2, 1, 3, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 2,
			1, 1, 2, 1, 2, 1, 2, 2, 2, 0, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 0, 2, 2, 2, 3, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 1, 2, 1, 2,
			1, 2, 0, 1, 2, 2, 1, 2, 1, 2, 3, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 0, 2, 1, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 0,

			/* 1971 */1, 2, 1, 1, 2, 3, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 0, 2, 1, 2, 1, 1, 2, 1, 1, 2, 2, 2, 1, 0, 2, 2, 1,
			2, 3, 1, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 0, 2, 2, 1, 2, 1, 2, 1, 2, 3, 2, 1, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2,
			1, 1, 0, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 0, 2, 1, 1, 2, 1, 2, 4, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 0,

			/* 1981 */1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 0, 2, 1, 2, 1, 3, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 0, 2, 1, 2,
			2, 1, 1, 2, 1, 1, 2, 3, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 0, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 1, 0, 2, 1, 2, 2, 1, 2, 3, 2, 2, 1,
			2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 0, 2, 1, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 0, 1, 2, 1, 1, 2, 3, 1, 2, 1, 2, 2, 2, 2,

			/* 1991 */1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 2, 0, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 0, 1, 2, 2, 3, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2,
			1, 2, 1, 2, 1, 1, 2, 1, 2, 0, 1, 2, 2, 1, 2, 2, 1, 2, 3, 2, 1, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 0, 1, 1, 2, 1, 2, 1, 2, 2, 1, 2,
			2, 1, 0, 2, 1, 1, 2, 1, 3, 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 2, 1, 0, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 1, 0,

			/* 2001 */2, 2, 2, 1, 3, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 0, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 0, 1, 2, 3,
			2, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 0, 1, 1, 2, 1, 2, 1, 2, 3, 2, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 2,
			1, 2, 0, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 0, 2, 2, 1, 1, 2, 3, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 0,

			/* 2011 */2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 0, 2, 1, 2, 4, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 1, 2, 1,
			2, 1, 2, 1, 2, 2, 3, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 2, 2, 1, 2, 2, 0, 1, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 2, 0, 2, 1, 1, 2, 1, 3, 2, 1, 2, 1,
			2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 0, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 0, 2, 1, 2, 2, 3, 2, 1, 1, 2, 1, 2, 1, 2,

			/* 2021 */1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 0, 1, 2, 3, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1,
			1, 2, 1, 2, 2, 1, 2, 2, 1, 0, 2, 1, 2, 1, 1, 2, 3, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 0, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2,
			2, 2, 0, 1, 2, 2, 1, 2, 3, 1, 2, 1, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 2, 0, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 0,

			/* 2031 */2, 1, 2, 3, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 0, 1, 2, 1, 1, 2, 1, 2, 3, 2, 2, 2, 1, 2, 1, 2, 1,
			1, 2, 1, 2, 1, 2, 2, 2, 1, 0, 2, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2, 0, 2, 2, 1, 2, 1, 1, 4, 1, 1, 2, 1, 2, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2,
			1, 2, 0, 2, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 0, 2, 2, 1, 2, 2, 3, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 0,

			/* 2041 */2, 1, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 0, 1, 2, 3, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 0 };

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////The
	// Date to Calc.

	private static SunToLunar	INNER_INSTANCE	= null;

	static {
		INNER_INSTANCE = new SunToLunar();
	}

	public synchronized static String Lunar(String year, String month, String day) {
		try {
			INNER_INSTANCE.Lunar(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
			return INNER_INSTANCE.getLunar();
		}
		catch(Exception ignore) {
			log.error("error", ignore);
		}

		return "--------";
	}

	/** Creates new SunToLunar */
	private SunToLunar() {
		for (i = 0; i < 163; i++) {
			dt[i] = 0;
			for (j = 0; j < 12; j++) {
				switch (kk[i * 13 + j]) {
					case 1:
					case 3:
						dt[i] = dt[i] + 29;
						break;
					case 2:
					case 4:
						dt[i] = dt[i] + 30;
				}
			}
			switch (kk[i * 13 + 12]) {
				case 0:
					break;
				case 1:
				case 3:
					dt[i] = dt[i] + 29;
					break;
				case 2:
				case 4:
					dt[i] = dt[i] + 30;
					break;
			}
		}
		td1 = 1880 * 365L + 1880 / 4 - 1880 / 100 + 1880 / 400 + 30;
	}

	private void Lunar(int year, int month, int day) {
		syear = year;
		smonth = month;
		sday = day;

		k11 = (syear - 1);
		td2 = k11 * 365L + k11 / 4L - k11 / 100L + k11 / 400L;
		ll = syear % 400 == 0 || syear % 100 != 0 && syear % 4 == 0;
		if( ll )
			m[1] = 29;
		else
			m[1] = 28;

		if( !verifyDate(syear, smonth, sday) ) {
			throw new RuntimeException("INVALID DATE");
		}

		for (i = 0; i < smonth - 1; i++)
			td2 = td2 + m[i];
		td2 = td2 + sday;

		/* ## 1881. 1. 30. - syear. smonth. sday. ## */
		td = td2 - td1 + 1;

		/* ## Lunar Year Caculation ## */
		td0 = dt[0];
		for (i = 0; i < 163; i++) {
			if( td <= td0 )
				break;
			td0 = td0 + dt[i + 1];
		}
		lyear = i + 1881; /* Calculated Lunar Year */

		/* ## Lunar Month Calculation ## */
		td0 = td0 - dt[i];
		td = td - td0;
		if( kk[i * 13 + 12] != 0 )
			jcount = 13;
		else
			jcount = 12;
		m2 = 0;
		for (j = 0; j < jcount; j++) {
			if( kk[i * 13 + j] <= 2 ){
				m2++;
			}
			if( kk[i * 13 + j] <= 2 ){
				m1 = kk[i * 13 + j] + 28;
			}
			else{
				m1 = kk[i * 13 + j] + 26;
			}
			if( td <= m1 )
				break;
			td = td - m1;
		}
		// m0 = j;
		lmonth = m2; /* Calculated Lunar Month */

		lday = (int) td; /* Calculated Lunar Day */
		// w = (short) (td2 % 7L); /* Week of Day */

		i = (int) ((td2 + 4L) % 10L);
		j = (int) ((td2 + 2L) % 12L);
		// i1 = ( lyear + 6 ) % 10;
		// j1 = ( lyear + 8 ) % 12;
	}

	private boolean verifyDate(int year, int month, int day) {
		if( year < 1881 || year > 2043 || month < 1 || month > 12 ) {
			return false;
		}

		if( day > m[month - 1] ) {
			return false;
		}

		return true;
	}

	private String getLunar() {
		String value = "";

		value = String.valueOf(lyear);
		if( lmonth < 10 )
			value += "0" + String.valueOf(lmonth);
		else
			value += String.valueOf(lmonth);

		if( lday < 10 )
			value += "0" + String.valueOf(lday);
		else
			value += String.valueOf(lday);

		return value;
	}
}
