/*
 * PlutoLinkedList.java
 *
 * Created on 2004년 2월 26일 (목), 오후 10:18
 */

package pluto.util;

import java.util.NoSuchElementException;

/**쓰레드 Safe로 설계되지 않음 한녀석만 사용해야한다. ^^
 *널을 집어넣을때는 근야 튕기기 때문에 null은 넣지 말아야 한다.
 *
 * @author  Administrator
 */
public class StringLinkedList {
	private transient Entry header = new Entry(null, null, null);
	
	private transient int size = 0;
	
	/**Iterator PART에서 사용한다.
	 */
	private Entry lastReturned = null;
	
	/** Creates a new instance of PlutoLinkedList */
	public StringLinkedList() {
		header.next = header.previous = header;
	}
	
	public void clear() {
		header.next = header.previous = header;
		size = 0;
	}
	
	public int size() {
		return size;
	}
	
	public synchronized void rewind() {
		lastReturned = header;
	}
	
	///////////////// Iterator 처럼 움직이기 위한 녀석들. //////////////////////
	
	public boolean hasNext() {
		return lastReturned.next != header;
	}
	
	public String next() {
		lastReturned = lastReturned.next;
		return lastReturned.element;
	}
	
	public void remove() {
		remove( lastReturned );
	}

	public boolean add(String obj) {
		addBefore(obj, header);
		return true;
	}
	
	public void addLast(String o) {
		addBefore(o, header);
	}
	
	public void addFirst(String o) {
		addBefore(o, header.next);
	}
	
	private void addBefore(String o, Entry e) {
		/**널은 넣지 않는다.
		 */
		if( o == null ){
			return;
		}
		Entry newEntry = new Entry(o, e, e.previous);
		newEntry.previous.next = newEntry;
		newEntry.next.previous = newEntry;
		size++;
		return;
	}
	
	public String removeFirst() {
		String first = header.next.element;
		remove(header.next);
		return first;
	}
	
	/**
	 * Removes and returns the last element from this list.
	 *
	 * @return the last element from this list.
	 * @throws    NoSuchElementException if this list is empty.
	 */
	public String removeLast() {
		String last = header.previous.element;
		remove(header.previous);
		return last;
	}
	
	private void remove(Entry e) {
		if (e == header)
			throw new NoSuchElementException();
		
		e.previous.next = e.next;
		e.next.previous = e.previous;
		size--;
	}
	
	private static class Entry {
		String element;
		Entry next;
		Entry previous;
		
		Entry(String element, Entry next, Entry previous) {
			this.element = element;
			this.next = next;
			this.previous = previous;
		}
	}
	
	
	/////////////////// Object PART /////////////////////////
	
	public synchronized String toString(){
		
		StringBuffer buffer = null;
		
		try{
			buffer = new StringBuffer(512);
			buffer.setLength( 0 );
			buffer.append( "[" );
			for( this.rewind(); this.hasNext(); ){
				buffer.append( this.next() );
				buffer.append( "," );
			}
			
			buffer.setLength( buffer.length() -1 );
			buffer.append( "]" );
			return buffer.toString();
		}
		catch( RuntimeException e ){
			throw e;
		}
		finally{
			buffer = null;
		}
	}
}
