/*
 * StringConvertUtil.java
 *
 * Created on 2004년 5월 27일 (목), 오후 8:9
 */

package pluto.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

import pluto.io.eMsByteArrayOutputStream;
import pluto.io.eMsStringWriter;
import pluto.lang.ByteArrayContainer;
import lombok.extern.slf4j.Slf4j;
import pluto.util.convert.DelimConvertor;
import freemarker20.template.SimpleHash;
import freemarker20.tm.TemplateHashModelData;
import freemarker20.tm.TemplateHashModelListTM;
/**
 *
 */
public class StringConvertUtil {
	
	public static final void ConvertString(StringBuffer tmpBuffer, String src, Object MAP, String start, String end, Object MAP2, String start2,
			String end2, boolean query, boolean empty) {
		if( src == null )
			return;
		if( MAP == null ) {
			tmpBuffer.append(src);
			return;
		}

		Map map = null;
		Properties mapProperty = null;
		if( MAP instanceof Properties ) {
			mapProperty = (Properties) MAP;
		}
		else if( MAP instanceof Map ) {
			map = (Map) MAP;
		}
		else if( MAP instanceof SimpleHash ) {
			map = ((SimpleHash) MAP).getAsHashmap();
		}
		if( map == null && mapProperty == null ) {
			throw new RuntimeException("UNSUPPORTED HASH TYPE");
		}

		boolean secondMappingFlag = ( MAP2 != null && start2 != null && end2 != null );
		int idx1 = 0;
		int idx2 = 0;
		int idx3 = 0;

		String key = null;
		Object value = null;

		while (true) {
			idx1 = src.indexOf(start, idx3);
			if( idx1 < 0 )
				break;

			idx2 = src.indexOf(end, idx1 + start.length());
			if( idx2 < 0 )
				break;

			key = src.substring(idx1 + start.length(), idx2);

			if( key.startsWith("util.") ) {
				try {
					value = StringUtil.getStringUtilMethodResult(key, map==null?mapProperty:map);
				}
				catch(Throwable thw) {
					value = "<!-- " + thw.toString() + "-->";
				}
			}
			else if( map == null ) {
				value = mapProperty.getProperty(key);
			}
			else {
				value = map.get(key);
			}

			tmpBuffer.append(src.substring(idx3, idx1));
			if( value == null ) {
				if( empty ) {
					tmpBuffer.append(start);
					tmpBuffer.append(key);
					tmpBuffer.append(end);
				}
			}
			else {
				if( query ) {
					ConvertString(tmpBuffer, value.toString(), "'", "''");
				}
				else {
					// 2차 매핑이면 매핑을 해야한다.
					if( secondMappingFlag ) {
						ConvertString(tmpBuffer, value.toString(), MAP2, start2, end2, query, empty);
					}
					else {
						tmpBuffer.append(value.toString());
					}
				}
			}

			idx3 = idx2 + end.length();
		}

		tmpBuffer.append(src.substring(idx3));

		return;
	}	
	/**가끔 한번씩 사용하는 변환을 위해서 생성한 메소드
	 * eMsStringBuffer에서 하나꺼내서 한번 변환하고 반환한다.
	 * **주의** 반복루틴에서 사용할 경우 FIFOBuffer를 반복하는 수만큼 호출하게 되므로 반복 루틴에서는 외부에서 하나의 인스턴스를
	 * 할당 받아서 처리해야함.
	 */
	public static final String ConvertString( String src,Object MAP,String start,String end, boolean query , boolean empty ) {
		StringBuffer tmpBuffer = null;
		try{
			tmpBuffer = new StringBuffer(512);
			ConvertString( tmpBuffer , src , MAP , start , end , query , empty );
			return tmpBuffer.toString();
		}
		finally{
			tmpBuffer = null;
		}
	}
	
	public static final void ConvertString( StringBuffer tmpBuffer , String src,Object MAP,String start,String end, boolean query , boolean empty ) {
		if( src == null ) return;
		if( MAP == null ){
			tmpBuffer.append( src );
			return;
		}
		
		Map map = null;

		if( MAP instanceof Properties ){
			ConvertString( tmpBuffer , src , (Properties)MAP , start , end , query , empty );
			return;
		}
		else if( MAP instanceof Map ){
			map = ( Map )MAP;
		}
		else if( MAP instanceof SimpleHash ){
			map = ( ( SimpleHash)MAP).getAsHashmap();
		}
		else{
			throw new RuntimeException("UNSUPPORTED HASH TYPE");
		}
		
		int idx1 = 0 ;
		int idx2 = 0;
		int idx3 = 0;
		
		String key = null;
		Object value = null;
		
		while( true ) {
			idx1 = src.indexOf(start,idx3);
			if( idx1 < 0 ) break;
			
			idx2 = src.indexOf(end,idx1 + start.length());
			if( idx2 < 0 ) break;
			
			key = src.substring( idx1 + start.length() , idx2 );
			value = map.get( key );
			
			tmpBuffer.append( src.substring(idx3,idx1) );
			if( value == null ){
				if( empty ){
					tmpBuffer.append( start );
					tmpBuffer.append( key );
					tmpBuffer.append( end );
				}
			}
			else{
				if( query ){
					ConvertString( tmpBuffer , value.toString() , "'" , "''");
				}
				else{
					tmpBuffer.append( value.toString() );
				}
			}
			
			idx3 = idx2 + end.length();
		}
		
		tmpBuffer.append( src.substring(idx3) );
		
		return;
	}
		
	public static final void ConvertString( StringBuffer tmpBuffer , String src,Properties map,String start,String end, boolean query , boolean empty ) {
		if( src == null ) return;
		if( map == null ){
			tmpBuffer.append( src );
			return;
		}
		
		int idx1 = 0 ;
		int idx2 = 0;
		int idx3 = 0;
		
		String key = null;
		Object value = null;
		
		while( true ) {
			idx1 = src.indexOf(start,idx3);
			if( idx1 < 0 ) break;
			
			idx2 = src.indexOf(end,idx1 + start.length());
			if( idx2 < 0 ) break;
			
			key = src.substring( idx1 + start.length() , idx2 );
			value = map.getProperty( key );
			
			tmpBuffer.append( src.substring(idx3,idx1) );
			if( value == null ){
				if( empty ){
					tmpBuffer.append( start );
					tmpBuffer.append( key );
					tmpBuffer.append( end );
				}
			}
			else{
				if( query ){
					ConvertString( tmpBuffer , value.toString() , "'" , "''");
				}
				else{
					tmpBuffer.append( value.toString() );
				}
			}
			
			idx3 = idx2 + end.length();
		}
		
		tmpBuffer.append( src.substring(idx3) );
		
		return;
	}
	
	
	public static final void ConvertString( StringBuffer tmpBuffer , String source,String target,String dest) {
		if( source == null ) return;
		
		int idx1 = 0;
		int idx2 = 0;
		
		while( true ) {
			idx1 = source.indexOf( target , idx2 );
			
			if( idx1 < 0 ) break;
			
			tmpBuffer.append( source.substring( idx2 , idx1 ) );
			tmpBuffer.append( dest );
			
			idx2 = idx1 + target.length();
		}
		
		tmpBuffer.append( source.substring( idx2) );
		
		return;
	}
		
	
	public static final String ConvertStreamToString( InputStream in , String enc ) throws Exception {
		eMsByteArrayOutputStream __BUFFER__ = null;
		
		byte[] buffer = null;
		
		try{
			__BUFFER__ = eMsByteArrayOutputStream.getInstance();
			//받아온 버퍼를 청소한다.
			__BUFFER__.flush();
			__BUFFER__.reset();
			
			buffer = ByteArrayContainer.getInstance();
			
			while(true) {
				int bytes = in.read(buffer);
				if (bytes < 0)
					break;
				
				__BUFFER__.write( buffer , 0 , bytes );
			}
			
			__BUFFER__.flush();
			
			return enc == null? __BUFFER__.toString() : __BUFFER__.toString( enc );
		}
		catch( Exception e ){
			throw e;
		}
		finally{
			ByteArrayContainer.recycleInstance( buffer );
			eMsByteArrayOutputStream.recycleInstance( __BUFFER__ );
		}
	}
	
	/**라인이 "." 으로만 되어 있으면 통신상에서 컨텐츠 마지막을 가리키기 때문에 ".." 이걸로 치환한다.
	 */
	public static String GeneralizeMailContents( String src ) {
		if( src == null ) return "";
		
		StringBuffer tmpBuffer = null;
		BufferedReader b = null;
		try{
			tmpBuffer = new StringBuffer(512);
			tmpBuffer.setLength( 0 );
			
			b = new BufferedReader( new StringReader( src ) );
			
			String tmp = null;
			while( b.ready() ) {
				tmp = b.readLine();
				
				if( tmp == null ) break;
				
				tmp = tmp.trim();
				//[JOO] style 세팅에서 '.'으로 시작하는 문자가 많이 있음. 이때 '..'으로 변환되서 스타일이 안먹는 경우가 발생함.
				// startWith가 아니라 trim 했을 경우 equal을 처리해야함.
				// 의미없이 엔터값이 연속으로 있을 경우 삭제처리했음.
				if( tmp.startsWith(".") ) {
				tmpBuffer.append( "." );
				}

				if(tmp.length() > 0){
					if( tmp.equals(".") ) {
						tmpBuffer.append( "." );
					}
					tmpBuffer.append( tmp );
					tmpBuffer.append("\r\n");
				}
			}
			
			return tmpBuffer.toString();
		}
		catch( Exception e ){
			return src;
		}
		finally{
			tmpBuffer = null;
			try{ b.close(); }catch( Exception e ){}
		}
	}
	
	public static final void ConvertMapToString( StringBuffer tmpBuffer , Properties prop ) {
		if( prop == null ) return;
		for( Enumeration eNum = prop.propertyNames(); eNum.hasMoreElements(); ){
			String key = eNum.nextElement().toString();
			tmpBuffer.append("[");
			tmpBuffer.append( key );
			tmpBuffer.append("|");
			DelimConvertor.encodeToBuffer( tmpBuffer , prop.getProperty( key ) );
			tmpBuffer.append("]");
		}
	}
	
	public static final void ConvertStringToSimpleHash( SimpleHash _MEMBER_HASH_ , String mapping ){
		if( mapping == null ) return;
		
		int idx_start = mapping.indexOf("&LIST&");
		int idx_end = -1;
		int loop_index = 1;
		if(  idx_start > 0 ){
			ConvertStringToSimpleHashSimple( _MEMBER_HASH_ , mapping , 0 , idx_start );
			while( true ){
				idx_end = mapping.indexOf("&LIST&" , idx_start + 1);
				if( idx_end < 0 ) break;
				ConvertStringToSimpleHashLoop( _MEMBER_HASH_ , "rap_" + String.valueOf( loop_index++ ) , mapping , idx_start , idx_end );
				idx_start = idx_end;
			}
			
			ConvertStringToSimpleHashLoop( _MEMBER_HASH_ , "rap_" + String.valueOf( loop_index++ ) , mapping, idx_start , mapping.length() );
		}
		else{
			ConvertStringToSimpleHashSimple( _MEMBER_HASH_ , mapping , 0 , mapping.length() );
		}
	}
	
	public static final void ConvertStringToSimpleHashLoop( SimpleHash _MEMBER_HASH_ , String loop_index , String mapping , int start , int end ) {
		int idxStart = 0;
		int idxEnd = start;
		TemplateHashModelListTM myMapping = new TemplateHashModelListTM();
		while( true ){
			idxStart = mapping.indexOf( "{" , idxEnd );
			
			if( idxStart < 0 || idxStart > end ){
				break;
			}

			idxEnd = mapping.indexOf( "}" , idxStart );
			
			if( idxEnd < 0 ){
				break;
			}

			putStringToVarList( myMapping , mapping , idxStart + 1 , idxEnd );
		}
		_MEMBER_HASH_.put( loop_index , myMapping );
	}
	
	private static final void putStringToVarList( TemplateHashModelListTM myMapping , String mapping , int start , int end ) {
		
		int idxStart = 0;
		int idxMiddle = 0;
		int idxEnd = start;
		TemplateHashModelData data = new TemplateHashModelData();
		while( true ){
			idxStart = mapping.indexOf( "[" , idxEnd );
			
			if( idxStart < 0 || idxStart > end ){
				break;
			}

			idxMiddle = mapping.indexOf( "|" , idxStart );
			
			if( idxMiddle < 0 ){
				break;
			}

			idxEnd = mapping.indexOf( "]" , idxMiddle );
			
			if( idxEnd < 0 ){
				break;
			}
			data.put( mapping.substring( idxStart + 1 , idxMiddle ) , DelimConvertor.decode( mapping.substring( idxMiddle + 1 , idxEnd ) ) );
		}
		
		myMapping.addEntry(data);
	}
	
	public static final void ConvertStringToSimpleHashSimple( SimpleHash _MEMBER_HASH_ , String mapping , int start , int end ) {
		int idxStart = 0;
		int idxMiddle = 0;
		int idxEnd = start;
		
		while( true ){
			idxStart = mapping.indexOf( "[" , idxEnd );
			
			if( idxStart < 0 || idxStart > end ){
				break;
			}

			idxMiddle = mapping.indexOf( "|" , idxStart );
			
			if( idxMiddle < 0 ){
				break;
			}

			idxEnd = mapping.indexOf( "]" , idxMiddle );
			
			if( idxEnd < 0 ){
				break;
			}
			// log.debug( mapping.substring( idxStart + 1 , idxMiddle ) + " ==> " + DelimConvertor.decode( mapping.substring( idxMiddle + 1 , idxEnd ) ) );
			_MEMBER_HASH_.put( mapping.substring( idxStart + 1 , idxMiddle ) , DelimConvertor.decode( mapping.substring( idxMiddle + 1 , idxEnd ) ) );
		}
	}
	
	public static final void ConvertStringToProperty( Properties _MEMBER_HASH_ , String mapping ) {
		if( mapping == null ) return;
		
		int idxStart = 0;
		int idxMiddle = 0;
		int idxEnd = 0;
		
		while( true ){
			idxStart = mapping.indexOf( "[" , idxEnd );
			
			if( idxStart < 0 ){
				break;
			}

			idxMiddle = mapping.indexOf( "|" , idxStart );
			
			if( idxMiddle < 0 ){
				break;
			}

			idxEnd = mapping.indexOf( "]" , idxMiddle );
			
			if( idxEnd < 0 ){
				break;
			}

			_MEMBER_HASH_.setProperty( mapping.substring( idxStart + 1 , idxMiddle ) , mapping.substring( idxMiddle + 1 , idxEnd ) );
		}
	}
	
	public static String ppsParseSQL(String source, String mapping, String value,String start, String end) {

		if( mapping == null || source == null )
			return source;

		return replace_target(source, start + mapping + end, value);
	}
	
	public static String replace_target(String target, String from, String to) {
		if( target == null || from == null || to == null )
			return null;

		int idx1 = 0;
		int idx2;

		while ((idx2 = target.indexOf(from, idx1)) != -1) {
			target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
			idx1 = idx2 + to.length();
		}
		return target;
	}
	
	
	public static void LeftPadding( StringBuffer tmpBuffer , String src , char padding , int size ){
		if( src == null ){
			src = "";
		}
		
		for( int i = size - src.length(); i > 0 ; i-- ){
			tmpBuffer.append( padding );
		}
		
		tmpBuffer.append( src );
	}
	
	public static final String trimNull( Object src ){
		if( src == null ) return "";
		
		return src.toString().trim();
	}
	
	private static eMsStringWriter INNER_EXCEPTION_PROCESS_STRING_WRITER = null;
	private static PrintWriter INNER_EXCEPTION_PROCESS_PRINT_WRITER = null;
	static{
		INNER_EXCEPTION_PROCESS_STRING_WRITER = new eMsStringWriter();
		INNER_EXCEPTION_PROCESS_PRINT_WRITER = new PrintWriter( INNER_EXCEPTION_PROCESS_STRING_WRITER );
	}
	/** 스택정보를 스트링으로 변환한다.
	 * @param ex 변환할 Throwable Object
	 * @return 스택정보 변환한 스트링
	 */
	
	
	public static final String exToString( Throwable ex ) {
		return exToString( null , ex );
	}
	
	public static final String exToString( String name , Throwable ex ) {
		try {
			synchronized( INNER_EXCEPTION_PROCESS_STRING_WRITER ){
				INNER_EXCEPTION_PROCESS_STRING_WRITER.reset();
				if( name != null ){
					INNER_EXCEPTION_PROCESS_PRINT_WRITER.write( name );
					INNER_EXCEPTION_PROCESS_PRINT_WRITER.println( "=>" );
				}
				ex.printStackTrace(INNER_EXCEPTION_PROCESS_PRINT_WRITER);
				if( ex instanceof SQLException ){
					SQLException sex = ( SQLException )ex;
					INNER_EXCEPTION_PROCESS_PRINT_WRITER.write( "ErrorCode:" );
					INNER_EXCEPTION_PROCESS_PRINT_WRITER.write( String.valueOf( sex.getErrorCode() ) );
					INNER_EXCEPTION_PROCESS_PRINT_WRITER.write( "\r\n" );
					INNER_EXCEPTION_PROCESS_PRINT_WRITER.write( "SqlState:" );
					INNER_EXCEPTION_PROCESS_PRINT_WRITER.write( sex.getSQLState() );
					INNER_EXCEPTION_PROCESS_PRINT_WRITER.write( "\r\n" );
				}
				return INNER_EXCEPTION_PROCESS_STRING_WRITER.toString();
			}
		}
		catch( Throwable e ) {
			return ex.toString();
		}
	}
}
