/*
 * PlutoLinkedList.java
 *
 * Created on 2004년 2월 26일 (목), 오후 10:18
 */

package pluto.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

import lombok.extern.slf4j.Slf4j;

/**쓰레드 Safe로 설계되지 않는 한녀석만 사용해야한다. ^^
 *널을 집어넣을때는 근야 튕기기 때문에 null은 넣지 말아야 한다.
 *
 * @author  Administrator
 */
@Slf4j
public class PlutoLinkedList implements List , Iterator {
	private transient Entry header = new Entry(null, null, null);
	
	private transient int size = 0;
	
	/**Iterator PART에서 사용한다.
	 */
	private Entry lastReturned = null;
	
	/** Creates a new instance of PlutoLinkedList */
	public PlutoLinkedList() {
		header.next = header.previous = header;
	}
	
	public void clear() {
		header.next = header.previous = header;
		size = 0;
	}
	
	public int size() {
		return size;
	}
	
	public java.util.Iterator iterator() {
		lastReturned = header;
		return this;
	}
	
	/** addListd와 동일한 로직으로 움직인다.
	*/
	public boolean add(Object obj) {
		addBefore(obj, header);
		return true;
	}
	
	public void addLast(Object o) {
		addBefore(o, header);
	}
	
	public void addFirst(Object o) {
		addBefore(o, header.next);
	}
	
	private void addBefore(Object o, Entry e) {
		/**널은 넣지 않는다.
		 */
		if( o == null ){
			return;
		}
		Entry newEntry = new Entry(o, e, e.previous);
		newEntry.previous.next = newEntry;
		newEntry.next.previous = newEntry;
		size++;
		return;
	}
	public Object removeFirst() {
		Object first = header.next.element;
		remove(header.next);
		return first;
	}
	
	/**
	 * Removes and returns the last element from this list.
	 *
	 * @return the last element from this list.
	 * @throws    NoSuchElementException if this list is empty.
	 */
	public Object removeLast() {
		Object last = header.previous.element;
		remove(header.previous);
		return last;
	}
	
	private void remove(Entry e) {
		if (e == header)
			throw new NoSuchElementException();
		
		e.previous.next = e.next;
		e.next.previous = e.previous;
		size--;
	}
	
	private static class Entry {
		Object element;
		Entry next;
		Entry previous;
		
		Entry(Object element, Entry next, Entry previous) {
			this.element = element;
			this.next = next;
			this.previous = previous;
		}
	}
	
	///////////////// Iterator PART //////////////////////
	
	public boolean hasNext() {
		return lastReturned.next != header;
	}
	
	public Object next() {
		if(!hasNext()) throw new NoSuchElementException();
		lastReturned = lastReturned.next;
		return lastReturned.element;
	}
	
	public void remove() {
		remove( lastReturned );
	}
	
	/////////////////// Object PART /////////////////////////
	
	public synchronized String toString(){
		
		StringBuffer buffer = null;
		
		try{
			buffer = new StringBuffer(512);
			buffer.append( "[" );
			for( Iterator iter = this.iterator(); iter.hasNext(); ){
				buffer.append( iter.next().toString() );
				buffer.append( "," );
			}
			
			buffer.setLength( buffer.length() -1 );
			buffer.append( "]" );
			return buffer.toString();
		}
		catch( RuntimeException e ){
			throw e;
		}
		finally{
			buffer = null;
		}
	}
	
	public static void main( String[] arg ) throws Exception{
		PlutoLinkedList list = new PlutoLinkedList();
		int idx = 0;
		list.addLast( String.valueOf( idx++ ) );
		list.addLast( String.valueOf( idx++ ) );
		list.addLast( String.valueOf( idx++ ) );
		list.addLast( String.valueOf( idx++ ) );
		list.addLast( String.valueOf( idx++ ) );
		list.addLast( String.valueOf( idx++ ) );
		
		for( Iterator iter = list.iterator(); iter.hasNext(); ){
			log.debug( iter.next().toString() );
		}
		
		log.debug( list.toString() );
		
		list.clear();
		
		list.addLast( "-2" );
		list.addLast( "-3" );
		list.addFirst( "-1" );
		list.addLast( "-4" );
		list.addFirst( "-0" );
		
		for( Iterator iter = list.iterator(); iter.hasNext(); ){
			log.debug( iter.next().toString() );
		}
	}
	
	///////////////////////////////////
	
	public boolean remove(Object obj) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public java.util.ListIterator listIterator() {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public boolean contains(Object obj) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public boolean containsAll(java.util.Collection collection) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public Object get(int param) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public int indexOf(Object obj) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public boolean isEmpty() {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public int lastIndexOf(Object obj) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public java.util.ListIterator listIterator(int param) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public Object remove(int param) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public boolean removeAll(java.util.Collection collection) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public boolean retainAll(java.util.Collection collection) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public Object set(int param, Object obj) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public java.util.List subList(int param, int param1) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public Object[] toArray() {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public Object[] toArray(Object[] obj) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public void add(int param, Object obj) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public boolean addAll(java.util.Collection collection) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	public boolean addAll(int param, java.util.Collection collection) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
	//////////////////////////////////////
}
