package pluto.util;

import java.util.List;
import java.util.Map;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;

@Slf4j
public class FilterUtils {
	
	protected final int	COMMIT_INTEVER = 1000;
	private static String QUERY_FILTER_INSERT_SEND_LIST	= null;	
	private static String QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE = null;	
  
	static {
		try {
			QUERY_FILTER_INSERT_SEND_LIST = SqlManager.getQuery("PUSH_RESEND_TARGET", "QUERY_FILTER_INSERT_SEND_LIST");	//실패된 건 auto_send_list에 INSERT
			QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE = SqlManager.getQuery("COMMON", "QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE");
		} catch (Exception e) {
			log.error("query load fail", e);
			System.exit(1);
		}
	}
	
	public void procFilterResult(List<Map<String, String>> list, Properties schdInfo) throws Exception {
		//sendList 인서트.
		this.insertFiltersSendList(list,schdInfo);
	}
	
	
	public int insertFiltersSendList(List<Map<String, String>> list, Properties schdInfo) throws Exception {
		int insertCnt = 0;
		eMsConnection conn = null;
		eMsPreparedStatement ps = null;
		eMsPreparedStatement psSelectNextSeq = null;
		StringBuffer buffer = new StringBuffer(1024);

		
		try {
			conn = ConnectionPool.getConnection();
			conn.setAutoCommit(false);
			
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_FILTER_INSERT_SEND_LIST, schdInfo, "${", "}", true, false);
			ps = conn.prepareStatement(buffer.toString(), "@{", "}");
			
			int commitRetCnt = 0;
			for(Map<String, String> map : list) {
				insertCnt++;
				commitRetCnt++;
				ps.addBatch(map);
				if(commitRetCnt % COMMIT_INTEVER == 0){
					ps.executeBatch();
					conn.commit();
				}
			}
			ps.executeBatch();
			conn.commit();
		} catch (Exception e) {
			log.error("error:",e);
			conn.rollback();
			insertCnt = 0;
			
			buffer.setLength(0);
			eMsResultSet rsNextSeq = null;
			StringConvertUtil.ConvertString(buffer, QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE, schdInfo, "${", "}", true, false);
			psSelectNextSeq = conn.prepareStatement(buffer.toString(), "@{", "}");
			for(Map<String, String> map : list) {
				try{
					String nextMemberSeq = "";
					rsNextSeq = psSelectNextSeq.executeQuery(map);
					if (rsNextSeq.next()) {
						nextMemberSeq = rsNextSeq.getString(1) == null ? "" : rsNextSeq.getString(1);
					}
					
					if (!"".equals(nextMemberSeq)) {
						map.put("TMS_M_ID_SEQ", nextMemberSeq);
						insertCnt += ps.executeUpdate(map);
						conn.commit();
					}					
					
				}catch(Exception ex){
					log.error("Exception",ex);
					log.error("error :  {}",ex.getMessage());
				}
			}
		} finally {
			if(ps != null){
				conn.recycleStatement(ps);
			}
			if(conn != null){
				conn.commit();
				conn.setAutoCommit(true);
				conn.recycle();
			}
		}
		
		return insertCnt;
	}
	
}
