/*
 * FIFOBuffer.java
 *
 * Created on 2004년 1월 13일 (화), 오전 9:15
 */

package pluto.util;

import java.util.NoSuchElementException;
/**
 *
 * @author  t??
 */
public class FIFOBuffer {
	private transient Entry header = new Entry(null, null, null);
	private transient int size = 0;
	private int MAXIMUM_SIZE = -1;
	/** 새로운 FIFOBuffer 인스턴스를 생성합니다. */
	public FIFOBuffer( int max ) {
		header.next = header.previous = header;
		MAXIMUM_SIZE = max;
	}
	
	public synchronized void reSize( int max ){
		MAXIMUM_SIZE = max;
	}
	
	public synchronized boolean contains( Object o ) {
		return this.indexOf( o ) > 0;
	}
	
	public synchronized boolean push( Object o ) {
		if( o == null ){
			throw new NullPointerException( "CAN NOT INSERT NULL" );
		}
		
		// 사이즈가 0이거나 음수일 경우에는 무한대 이므로 조건 추가.
		if( MAXIMUM_SIZE > 0 && size >= MAXIMUM_SIZE ){
			return false;
		}
		
		addBefore(o, header);
		
		return true;
	}
	
	public synchronized Object pop() {
		if (size==0){
			return null;
		}
		Object first = header.next.element;
		remove(header.next);
		return first;
	}
	
	private void addBefore(Object o, Entry e) {
		Entry newEntry = new Entry(o, e, e.previous);
		newEntry.previous.next = newEntry;
		newEntry.next.previous = newEntry;
		size++;
	}
	
	public synchronized boolean remove(Object o) {
		if (o==null) {
			return false;
		}
		
		for (Entry e = header.next; e != header; e = e.next) {
			if (o.equals(e.element)) {
				remove(e);
				return true;
			}
		}
		
		return false;
	}
	
	private void remove(Entry e) {
		if (e == header)
			throw new NoSuchElementException();
		
		e.previous.next = e.next;
		e.next.previous = e.previous;
		size--;
	}
	
	private int indexOf(Object o) {
		int index = 1;
		if (o==null) {
			return -1;
		}
		
		for (Entry e = header.next; e != header; e = e.next) {
			if (o.equals(e.element))
				return index;
			index++;
		}
		return -1;
	}
	
	public int size(){
		return size;
	}
	
	private static class Entry {
		Object element;
		Entry next;
		Entry previous;
		
		Entry(Object element, Entry next, Entry previous) {
			this.element = element;
			this.next = next;
			this.previous = previous;
		}
	}
}
