package pluto.util;

import java.io.File;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

import org.apache.xmlbeans.impl.util.Base64;

import pluto.io.eMsFileReader;
import lombok.extern.slf4j.Slf4j;
import pluto.util.convert.MD5;

@Slf4j
public class EmsLock {

	private String path = "";
	
	private String fileName = "lock.ser";
	
	private String threadInfo_name = "mail_thread_size.info";
	
	private String sec1 = "";
	
	private String sec2 = "";
	
	private String SUPER_KEY="040121de91516d2cd1cd24af9bc56f34";
	
	public EmsLock( String id, String path) {		
		this.sec1 = id;
		this.path = path;
	}
	
	public boolean check() {
		
		eMsFileReader reader = null;
		boolean chk = false;
		
		try {
			reader = new eMsFileReader(this.path+File.separator+this.fileName);			
			String line = reader.readLine();
			
			//엔진 localIP 조회시 루프백주소(127.0.0.1)가 리턴되는 현상 보완을 위한 로직 변경
//			InetAddress iaddr = InetAddress.getLocalHost();
//			this.sec2 = iaddr.getHostAddress();
			this.sec2 = getLocalServerIp();			
			
			log.debug("getLoaclServerIP : {}", getLocalServerIp());			
			
			if( line.equals(this.enc()) || line.equals(SUPER_KEY)) {
				chk = true;
			}
			
		} catch(Exception e) {
			
		} finally {
			try {
				if(reader != null) reader.close();
				
			} catch(Exception e) {};
		}
		
		
		return chk;
	}
	
	private String getLocalServerIp()
	{
		try
		{
		    for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements();)
		    {
		        NetworkInterface intf = en.nextElement();
		        for (Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses(); enumIpAddr.hasMoreElements();)
		        {
		            InetAddress inetAddress = enumIpAddr.nextElement();
		            
		            if (!inetAddress.isLoopbackAddress() && !inetAddress.isLinkLocalAddress() && inetAddress instanceof Inet4Address)
		            {
		            	return inetAddress.getHostAddress().toString();
		            }
		        }
		    }
		}
		catch (SocketException ex) {}
		return null;
	}
	
	public boolean check_thread_info(String key_value) {
		
		eMsFileReader reader = null;
		boolean chk = false;
		
		try {
			reader = new eMsFileReader(this.path+File.separator+this.threadInfo_name);
			String line = reader.readLine();
			
			if( line.trim().equals( new String(Base64.encode(key_value.getBytes())).trim() )) {
				chk = true;
			}
			
		} catch(Exception e) {
			log.error("error", e);
		} finally {
			try {				
				if(reader != null) reader.close();
			} catch(Exception e) {};
		}
		return chk;
	}
	
	
	
	public String enc() {
	
		String encStr = "";
		
		try {
			encStr = MD5.encodeS(sec1+sec2);
		} catch(Exception e) {
			//e.printStackTrace();
			log.error(e.getMessage());
		}
				
		return encStr;
	}
	
	public String getSec1() {
		return sec1;
	}

	public void setSec1(String sec1) {
		this.sec1 = sec1;
	}

	public String getSec2() {
		return sec2;
	}

	public void setSec2(String sec2) {
		this.sec2 = sec2;
	}

	public static void main(String[] args) {
		System.out.println(MD5.encodeS("humusonSuperKey"));				
		
		String id = "humuson";
		EmsLock lock = new EmsLock(id,"D:");
		if( lock.check() ) {
			
			log.debug("right");
		} else {
			
			log.debug("wrong");
		}		
		
	}
}
