package pluto.util;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.time.FastDateFormat;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class Cal {
	private static Date myDate = new Date();

	enum DateFormat {
        yyyyMMddHHmmss("yyyyMMddHHmmss"),
        yyyyMMddHHmmss_Std("yyyy-MM-dd HH:mm:ss"),
        yyyyMMdd("yyyyMMdd"),
        yyyyMMddHH("yyyyMMddHH"),
        yyyyMMddHHmmss_Dot("yyyy.MM.dd.HH.mm.ss"),
        HHmm("HHmm"),
        MailHeaderTime("EEE, dd MMM yyyy HH:mm:ss +0900"),
        WeekDay("E"),
        yyyyMMddHHmmssSS("yyyyMMddHHmmssSS"),
        yyyy("yyyy"),
        MM("MM"),
        dd("dd"),
        mm("mm"),
        HH("HH"),
        ss("ss"),
        yyyyMM("yyyyMM"),
        yyyyMMddHHmm("yyyyMMddHHmm");

        private final Format format;
        private final boolean englishLocale;

        DateFormat(String s) {
            englishLocale = (s.substring(0, 1).equalsIgnoreCase("E"));
            format = (englishLocale) ? FastDateFormat.getInstance(s, Locale.ENGLISH)
                    : FastDateFormat.getInstance(s, Locale.getDefault());
        }

        public String getDateTime(Date date) {
            return format.format(date);
        }
    }
	
	enum WeekDay {
        INS;
        private HashMap<String, String> weekHash = new HashMap<>();

        WeekDay() {
            weekHash.put("SUN", "A1");
            weekHash.put("MON", "A2");
            weekHash.put("TUE", "A3");
            weekHash.put("WED", "A4");
            weekHash.put("THU", "A5");
            weekHash.put("FRI", "A6");
            weekHash.put("SAT", "A7");
        }

        public String getWeek(String s) {
            return weekHash.get(s);
        }
    }

	public static void printWeekValues(int count) throws Exception {
		for (int i = 0; i < count; i++) {
			long date = System.currentTimeMillis() + 1000 * 60 * 60 * 24 * i;

			log.debug(getDate(date));
			log.debug(getWeekDay(date));
			log.debug("/");
			log.debug(getInnerWeekValue(date));
		}
	}

	protected static String getInnerWeekValue(long time) {
		myDate.setTime(time);
		return DateFormat.WeekDay.getDateTime(myDate).toUpperCase();
	}

	public synchronized static String getWeekDay() {
		return getWeekDay(System.currentTimeMillis());
	}

	public synchronized static String getWeekDay(long time) {
		myDate.setTime(time);		
		return WeekDay.INS.getWeek(DateFormat.WeekDay.getDateTime(myDate).toUpperCase()).toString();
	}

	public synchronized static String getHeaderDate() {
		return getHeaderDate(System.currentTimeMillis());
	}

	public synchronized static String getHeaderDate(long time) {
		myDate.setTime(time);
		return DateFormat.MailHeaderTime.getDateTime(myDate);
	}
	
	public synchronized static String getSerialDate() {
		return getSerialDate(System.currentTimeMillis());
	}
	
	public synchronized static String getSerialDateMilli() {
		return getSerialDateMilli(System.currentTimeMillis());
	}

	public synchronized static String getSerialDate(long time) {
		myDate.setTime(time);
		return DateFormat.yyyyMMddHHmmss.getDateTime(myDate);
	}
	
	public synchronized static String getSerialDateMilli(long time) {
		myDate.setTime(time);
		return DateFormat.yyyyMMddHHmmssSS.getDateTime(myDate);
	}
	
	public synchronized static String getYear() {
		return getYear(System.currentTimeMillis());
	}

	public synchronized static String getYear(long time) {
		myDate.setTime(time);
		return DateFormat.yyyy.getDateTime(myDate);
	}

	public synchronized static String getMonth() {
		return getMonth(System.currentTimeMillis());
	}

	public synchronized static String getMonth(long time) {
		myDate.setTime(time);
		return DateFormat.MM.getDateTime(myDate);

	}

	public synchronized static String getDay() {
		return getDay(System.currentTimeMillis());
	}

	public synchronized static String getDay(long time) {
		myDate.setTime(time);
		return DateFormat.dd.getDateTime(myDate);
	}

	public synchronized static String getHour() {
		return getHour(System.currentTimeMillis());
	}

	public synchronized static String getHour(long time) {
		myDate.setTime(time);
		return DateFormat.HH.getDateTime(myDate);
	}

	public synchronized static String getMin() {
		return getMin(System.currentTimeMillis());
	}

	public synchronized static String getMin(long time) {
		myDate.setTime(time);
		return DateFormat.mm.getDateTime(myDate);

	}

	public synchronized static String getSec() {
		return getSec(System.currentTimeMillis());
	}

	public synchronized static String getSec(long time) {
		myDate.setTime(time);
		return DateFormat.ss.getDateTime(myDate);

	}

	public synchronized static String getHHmm() {
		return getHHmm(System.currentTimeMillis());
	}

	public synchronized static String getHHmm(long time) {
		myDate.setTime(time);
		return DateFormat.HHmm.getDateTime(myDate);
	}

	public synchronized static String getYYYYMM() {
		return getYYYYMM(System.currentTimeMillis());
	}

	public synchronized static String getYYYYMM(long time) {
		myDate.setTime(time);
		return DateFormat.yyyyMM.getDateTime(myDate);
	}

	/**
	 * DB에서 사용하는 Date 타입의 시간을 반환한다. Type : String 형식 : year-month-day hours:minutes:seconds 예제 : 2000-07-11 00:00:00
	 */
	public synchronized static String getDate() {
		return getDate(System.currentTimeMillis());
	}

	public synchronized static String getDate(long time) {
		myDate.setTime(time);
		return DateFormat.yyyyMMddHHmmss_Std.getDateTime(myDate);
	}

	public synchronized static String getConvertDate(String src) throws java.text.ParseException {
		SimpleDateFormat fullTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return fullTime.format(fullTime.parse(src));
	}

	/**
	 * 로그에서 사용하는 형식의 시간을 반환한다. Type : String 예제 : 2000071113
	 * 
	 * @return 2000071113 형태의 년/월/일/시 형태의 스트링
	 */
	public synchronized static String getHourDate() {
		return getHourDate(System.currentTimeMillis());
	}

	public synchronized static String getHourDate(long time) {
		myDate.setTime(time);
		return DateFormat.yyyyMMddHH.getDateTime(myDate);

	}

	/**
	 * 로그에서 사용하는 형식의 시간을 반환한다. Type : String 예제 : 2000071113
	 * 
	 * @return 2000071113 형태의 년/월/일/시 형태의 스트링
	 */
	public synchronized static String getMinDate() {
		return getMinDate(System.currentTimeMillis());
	}

	public synchronized static String getMinDate(long time) {
		myDate.setTime(time);
		return DateFormat.yyyyMMddHHmm.getDateTime(myDate);
	}

	/**
	 * 마임포멧의 바운더리에 사용할 시간을 반환한다. Type : String 예제 : 2000.07.11.13
	 * 
	 * @return 2000071113 형태의 년/월/일/시/분/초 형태의 스트링
	 */
	public synchronized static String getBoundaryDate() {
		myDate.setTime(System.currentTimeMillis());
		return DateFormat.yyyyMMddHHmmss_Dot.getDateTime(myDate);

	}

	/**
	 * 로그에서 사용하는 형식의 시간을 반환한다. Type : String 예제 : 20000711
	 * 
	 * @return 20000711 형식의 년월일 형태의 시간
	 */
	public synchronized static String getDayDate() {
		return getDayDate(System.currentTimeMillis());
	}

	public synchronized static String getDayDate(long time) {
		myDate.setTime(time);
		return DateFormat.yyyyMMdd.getDateTime(myDate);
	}

	public synchronized static String getAddDayDate(int add_day) {
		return getDayDate(System.currentTimeMillis() + add_day * 1000 * 60 * 60 * 24L);
	}

	public synchronized static String getLunarDate() {
		return getLunarDate(System.currentTimeMillis());
	}

	public synchronized static String getLunarDate(long time) {
		myDate.setTime(time);
		return SunToLunar.Lunar(DateFormat.yyyy.getDateTime(myDate),
                DateFormat.MM.getDateTime(myDate),
                DateFormat.dd.getDateTime(myDate));
	}

	public synchronized static String getLunarDate(String year, String month, String day) {
		return SunToLunar.Lunar(year, month, day);
	}

	public synchronized static String getAddLunarDate(int add_day) {
		return getLunarDate(System.currentTimeMillis() + add_day * 1000 * 60 * 60 * 24L);
	}
}
