package pluto.secure.crypto;

import java.util.Properties;

import pluto.config.eMsSystem;
import pluto.lang.Tracer;
import pluto.util.StringUtil;

import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.HumusonEncryptor;

import lombok.extern.slf4j.Slf4j;


@Slf4j
public class CryptoUtil {
	public static final String TMS_DECRYPT_TAG = "<TMS_DECRYPT>";
	
	public static final String SOCIAL_ID   = "RRN_ENCR";   //주민번호
	public static final String CARD_NUM    = "CRDT_CARD_NO_ENCR";//카드번호
	public static final String ACCOUNT_NUM = "ACCN_NO_ENCR";//계좌번호
	public static final String TEL_NUM     = "TELNO_ENCR";//전화번호
	public static final String DETAIL_ADDR = "DTLAD_ENCR";//상세주소
	public static final String EMAIL_ADDR  = "EMAIL_ADDR_ENCR";//이메일주소
	public static final String SYSTEM_INFO = "SYSTM_DSMT_INFO_ENCR";//시스템식별정보
	
	private static String ENC_PA;
	private static String SAFEDB_USERID    = "";
	private static String SAFEDB_TABLENAME = "";
	private static String SAFEDB_CHARSET   = "";
	
	static {
		try {
			/*
			<PARAM>
				<class name="pluto.config.eMsSystem"/>
				.
				.
				.
				<ext name="safedb.userid">SAFEPOLICY</ext>
				<ext name="safedb.tablename">POLICY.POLICY_TB</ext>
				<ext name="safedb.charset">EUC-KR</ext>
				<ext name="safedb.debug">true</ext>
			</PARAM>
			 
			 */
			ENC_PA 			 = eMsSystem.getProperty("member.info.encrypt.key"		   , "amail0722!@");
			SAFEDB_USERID    = eMsSystem.getProperty("safedb.userid"   , "SAFEPOLICY");
			SAFEDB_TABLENAME = eMsSystem.getProperty("safedb.tablename", "POLICY.POLICY_TB");
			SAFEDB_CHARSET   = eMsSystem.getProperty("safedb.charset"  , "EUC-KR");
		}
		catch(Exception e) {
			Tracer.error("INIT ERROR", e);
		}
	}
	
    /**
     * @param str 평문 String
     * @return String 암호화된 String
     */
	public static String encrypt_test(String str, String colname) {
		if (StringUtil.isNull(str)) {
			return str;
		}
    	String test_str = "";
    	
    	//test
		test_str = ( new StringBuffer(str) ).reverse().toString();
		
		if(log.isDebugEnabled()) {
			Tracer.debug("COLUMN["+colname+"], PLAIN["+str+"], ENCRYPT["+test_str+"]");
		}
		
		return test_str;
	}
    
	public static String encrypt(String str, String colname) {
		if (StringUtil.isNull(str)) {
			return str;
		}
    	String enc_str = "";
    	
    	enc_str = HumusonEncryptor.encrypt(str, ENC_PA, false);
		
		if(log.isDebugEnabled()) {
			Tracer.debug("COLUMN["+colname+"], PLAIN["+str+"], ENCRYPT["+enc_str+"]");
		}
		
		return enc_str;
	}
	
	public static String decrypt_test(String str,String colname) {
		if (StringUtil.isNull(str)) {
			return str;
		}
    	String test_str = "";
    	
    	//test
		test_str = ( new StringBuffer(str) ).reverse().toString();
		
		if(log.isDebugEnabled()) {
			Tracer.debug("COLUMN["+colname+"], ENCRYPT["+str+"], DECRYPT["+test_str+"]");
		}
		
		return test_str;
	}
	
	public static String decrypt(String str, String colname) {
		return decrypt(str, colname, ENC_PA);
	}
	
	
	public static String decrypt(String str, String colname, String encPa) {
		if (StringUtil.isNull(str)) {
			return str;
		}
    	String dec_str = "";
    	try{
    		dec_str = HumusonDecryptor.decrypt(str, encPa, false);
    		if(log.isDebugEnabled()) {
    			Tracer.debug("COLUMN["+colname+"], PLAIN["+str+"], ENCRYPT["+dec_str+"]");
    		}
    		
    		return dec_str;
		
    	}catch(Exception e){
    		Tracer.error("Decrypt error", e);
    		return dec_str;
    	}
		
	}
	
	public static void main(String[] args){
		String a = null;
		try {
			a = "ru/p3uUZcx5Sa0N7dU//PiH9nuR+x+yXhXT+K7YXSls=";
	    	a = deEmailAddr(a);
	    	System.out.println(a);
		} catch (Exception e) {
			// TODO: handle exception
		}
		try {
			a = "iyYPtx0Z77YeWZ9pqHcdk5yVavDBjuABL/BOBJuyJb0=";
	    	a = deEmailAddr(a);
	    	System.out.println(a);
		} catch (Exception e) {
			// TODO: handle exception
		}
    	
    	
    	
		
	}
	
    
    /**
     * 주민번호
     * @param str
     * @return
     */
    public static String deSocialId(String str){
    	return decrypt(str, SOCIAL_ID);
    }
    public static String enSocialId(String str){
    	return encrypt(str, SOCIAL_ID);
    }
    /**
     * 카드번호
     * @param str
     * @return
     */
    public static String deCardNum(String str){
    	return decrypt(str, CARD_NUM);
    }
    public static String enCardNum(String str){
    	return encrypt(str, CARD_NUM);
    }
    /**
     * 계좌번호
     * @param str
     * @return
     */
    public static String deAccuntNum(String str){
    	return decrypt(str, ACCOUNT_NUM);
    }
    public static String enAccuntNum(String str){
    	return encrypt(str, ACCOUNT_NUM);
    }
    /**
     * 전화번호
     * @param str
     * @return
     */
    public static String deTelNum(String str){
    	return decrypt(str, TEL_NUM);
    }
    public static String enTelNum(String str){
    	return encrypt(str, TEL_NUM);
    }
    /**
     * 상세주소
     * @param str
     * @return
     */
    public static String deDetailAddr(String str){
    	return decrypt(str, DETAIL_ADDR);
    }
    public static String enDetailAddr(String str){
    	return encrypt(str, DETAIL_ADDR);
    }
    /**
     * 이메일주소
     * @param str
     * @return
     */
    public static String deEmailAddr(String str){
    	return decrypt(str, EMAIL_ADDR);
    }
    public static String enEmailAddr(String str){
    	return encrypt(str, EMAIL_ADDR);
    }
    /**
     * 시스템식별정보
     * @param str
     * @return
     */
    public static String deSystemInfo(String str){
    	return decrypt(str, SYSTEM_INFO);
    }
    public static String enSystemInfo(String str){
    	return encrypt(str, SYSTEM_INFO);
    }
}