/*
 * TaskWorker.java
 *
 * Created on 2003년 3월 5일 수, 오후 9:34
 */

package pluto.schedule;

import lombok.extern.slf4j.Slf4j;

/**Task 실행을 대행한다.
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public class TaskWorker extends Thread {
	
	
	private Task work = null;
	
	/** 기본 생성자
	 * @param group 쓰레드 그룹
	 * @param target 실행할 Task
	 */
	protected TaskWorker(ThreadGroup group , Task target) {
		super( group , target.getTaskID() + "'s Worker" );
		work = target;
	}
	
	/** Task 의 execute() method를 invoke하고 반환되는 결과에 따라<br>
	 * doErrorProcess() 나 setEnd() method를 invoke한다.
	 */
	public final void run() {
		if (log.isDebugEnabled()) {
			log.debug( "START " + getName() );
		}
		
		/* 일단 Task 의 execute를 invoke 하여 실행 */
		try {
			//if (log.isDebugEnabled())  log.debug( getName() + " execute  => " + this.work.getName() + ".execute() method " );
			this.work.internal_execute();
		}
		catch (Throwable error) {
			log.error( getName() , error );
		}
		if (log.isDebugEnabled()) {
			log.debug( "END " + getName() );
		}
	}
}
