/*
 * ScheduledMonitor.java
 *
 * Created on 2003년 3월 5일 수, 오후 10:48
 */

package pluto.schedule;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.Name;

/**
 * 주기적인 모니터링이 필요한 경우에 <br>
 * 모니터를 만드는 기본 루틴을 정의한다.
 * 
 * @author 이상근
 * @version 3.0
 */
@Slf4j
public abstract class ScheduledMonitor extends Name implements Runnable {
	private Object		lockOfScheduledMonitor			= null;

	protected Thread	internal_thread					= null;

	protected boolean	internal_thread_alive			= true;

	private long		INTERNAL_THREAD_CHECK_INTERVAL	= 60 * 1000L;

	/**
	 * 기본 모니터링 주기를 가지는 모니터를 생성한다.
	 */
	protected ScheduledMonitor() {
		this(60 * 1000L);
	}

	/**
	 * 주어진 모니터링 주기를 가진 모니터를 생성
	 * 
	 * @param size
	 *            모니터링 주기
	 */
	protected ScheduledMonitor(long size) {
		this(size, null);
	}

	protected ScheduledMonitor(String name) {
		this(60 * 1000L, name);
	}

	protected ScheduledMonitor(long size, String name) {
		INTERNAL_THREAD_CHECK_INTERVAL = size;

		this.setName(name);
	}

	public void start() {
		lockOfScheduledMonitor = new Object();

		internal_thread = getName() == null ? new Thread(this) : new Thread(this, getName());
		internal_thread.setPriority(Thread.NORM_PRIORITY);
		internal_thread.start();
	}

	/**
	 * 내부 모니터링 쓰레드를 종료시킨다.
	 */
	public void close() {
		internal_thread_alive = false;

		try {
			internal_thread.interrupt();
		}
		catch(Exception e) {
		}
	}

	protected void interruptInnerThread() {
		try {
			internal_thread.interrupt();
		}
		catch(Exception e) {
		}
	}

	/**
	 * 내부 모니터링 Thread가 실행하는 method <br>
	 * 무한루프를 돌며 check() method를 실행하는 method
	 */
	public void run() {
		while (this.internal_thread_alive) {
			try {
				Thread.sleep(INTERNAL_THREAD_CHECK_INTERVAL);
			}
			catch(Exception e) {
			}

			synchronized (lockOfScheduledMonitor) {
				try {
					check();
				}
				catch(Exception e) {
					log.error(getName(), e);
				}
			}
		}
	}

	/**
	 * 상속받은 Class에서 실제적으로 모니터링하는 로직
	 */
	protected abstract void check() throws Exception;
}
