/*
 * Reporter.java
 *
 * Created on 2003년 3월 5일 수, 오후 9:37
 */

package pluto.reporter;

import java.util.Properties;

import pluto.config.ReportMessageManager;
import lombok.extern.slf4j.Slf4j;
import pluto.util.StringConvertUtil;
/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public abstract class Reporter {
	/** Creates new Reporter */
	protected Reporter() {
	}
	
	protected static Reporter inter_reporter = null;
	
	/** 초기화 파라미터
	 * <PRE>&lt;TARGET name="REPORTER"&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;class name="Lib2002.reporter.Reporter"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="report.class" value="Lib2002.reporter.eMailReporter"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="header.file" value="${base}/conf/email_report_header.txt"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="return.path" value="dragon@amail.co.kr"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="send.email" value="dragon@amail.co.kr,s9331@hotmail.com"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="store.url" value="${base}/info"/&gt;
	 * &lt;/TARGET&gt;
	 * </PRE>
	 * <PRE>
	 * report.class : 리포팅 담당하는 Class
	 * header.file : email에서 헤더파일
	 * return.path : email발송시 리턴 패스
	 * send.email : 리포팅을 받을 메일주소 "," 로 구분을 하여 열거한다.
	 * store.url : 리포팅 내용을 파일로 기록할 디렉토리
	 * </PRE>
	 * @param prop 초기화 파라미터
	 * @throws Exception 초기화 에러시
	 */
	public synchronized static void init(Object prop) throws Exception {
		Properties tmp = (Properties)prop;
		String class_name = tmp.getProperty( "report.class" );
		inter_reporter = (Reporter)(Class.forName( class_name ).newInstance() );
		inter_reporter.inner_init( tmp );
	}
	
	/** 리포팅을 한다. 외부에서 바로 호출한다.
	 * @param POST_ID 메일 아이디
	 * @param Agent 호출자 이름
	 * @param key 메세지 키
	 * @param message 추가 메세지
	 */
	public static void report( String POST_ID , String Agent , String key , Throwable message ) {
		String report_string = ReportMessageManager.getProperty( key );
		String report_result =  inter_reporter.push( POST_ID , Agent , report_string , message );
		log.info( report_string + " report => " + report_result );
	}
	
	/**리포팅을 한다. 외부에서 바로 호출한다.
	 * @param POST_ID 메일 아이디
	 * @param Agent 호출자 이름
	 * @param key 메세지 키
	 * @param message 추가 메세지
	 */
	public static void report( String POST_ID , String Agent , String key , String message ) {
		String report_string = ReportMessageManager.getProperty( key );
		String report_result =  inter_reporter.push( POST_ID , Agent , report_string , message );
		log.info( report_string + " report => " + report_result );
	}
	
	/**리포팅을 한다. 외부에서 바로 호출한다.
	 * @param data.POST_ID 메일 아이디
	 * @param Agent 호출자 이름
	 * @param key 메세지 키
	 * @param message 추가 메세지
	 */
	public static void report( Properties prop , String message ) {
		String report_result =  inter_reporter.push( prop , message );
		log.info( message + " report => " + report_result );
	}
	
	/** 직접적인 Report 방법을 정의한다.
	 * @param POST_ID 메일 아아디
	 * @param Agent 실행 Instance 이름
	 * @param CODE 에러 코드
	 * @param message 에러 Stack
	 * @return 성공 여부
	 */
	public String push( String POST_ID , String Agent , String CODE , Throwable message ) {
		return this.push( POST_ID , Agent , CODE , StringConvertUtil.exToString( message ) );
	}
	
	/** 초기화에 필요한 prop를 인자로하여 구동초기설정을 한다.
	 * ReporterFactory가 초기화 될때 호출된다.
	 * @param prop 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public abstract void inner_init( Properties prop ) throws Exception;
	
	/** 직접적인 Report 방법을 정의한다.
	 * @param POST_ID 메일 아아디
	 * @param Agent 실행 Instance 이름
	 * @param CODE 에러 코드
	 * @param message 메세지
	 * @return 성공여부
	 */
	public abstract String push( String POST_ID , String Agent , String CODE , String message );
	
	public abstract String push( Properties prop , String message );
}
