/*
 * MailSendDomainFilter.java
 *
 * Created on 2004년 4월 9일 (금), 오후 1:52
 */

package pluto.panopticon.monitor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
/**
 *
 * @author  Administrator
 */
@Slf4j
public class MailSendDomainFilter {
	
	
	private static Hashtable DOMAIN_HASH = null;
	
	private static boolean INIT_FLAG = false;
	
	static {
		DOMAIN_HASH = new Hashtable();
		INIT_FLAG = false;
	}
	
	public static void init( Object tmp ) throws Exception{
		Properties prop = (Properties) tmp;			
		
		if(log.isDebugEnabled()){
			log.debug( "[MailSendDomainFilter]...[init]");
		}
		
		/**
		 * JOO 초기 필터데이터를 가져오는 부분
		 */
		eMsConnection EMS_CONNECTION = null;
		eMsStatement EMS_STATEMENT = null;
		eMsResultSet rs = null;
		boolean use_flag = false;
		
		String QUERY_DOMAIN_FILTER_LIST = SqlManager.getQuery("SEND_DOMAIN_FILTER","QUERY_DOMAIN_FILTER_LIST");
		String QUERY_DOMAIN_FILTER_YN = SqlManager.getQuery("SEND_DOMAIN_FILTER","QUERY_DOMAIN_FILTER_YN");
		
		
		Properties ppt = new Properties();
		ppt.setProperty("NOWTIME_LONG", ""+System.currentTimeMillis());
		if(log.isDebugEnabled()){
			log.debug( "[NOWTIME_LONG]..."+System.currentTimeMillis());
		}
		StringBuffer	TMP_STRING_BUFFER = new StringBuffer(1024);
		StringConvertUtil.ConvertString(TMP_STRING_BUFFER, QUERY_DOMAIN_FILTER_LIST, ppt, "${", "}", true, false);
		
		try{		
			EMS_CONNECTION = ConnectionPool.getConnection();
			EMS_STATEMENT = EMS_CONNECTION.createStatement();
			
			//리스트: 사용을 하든 안하든 리스트는 가져와서 등록해야한다.
			rs = EMS_STATEMENT.executeQuery(TMP_STRING_BUFFER.toString());
			while( rs.next() ) {				
				// 필터 도메인을 등록
				registeFilteringDomain(rs.getString("LIMIT_TIME"), rs.getString("DOMAIN") );
				log.info( "[LIMIT_TIME]"+rs.getString("LIMIT_TIME")+" [DOMAIN]"+rs.getString("DOMAIN"));
			}	
			
			// 사용유무
			rs = EMS_STATEMENT.executeQuery(QUERY_DOMAIN_FILTER_YN);
			if(rs.next()){
				log.info( "[USE_YN]..."+rs.getString("USE_YN"));
				if(rs.getString("USE_YN").equals("Y")){
					INIT_FLAG = true;
				}
			}
			
		}catch(Exception e){
			log.error("error", e);
		}
		finally {
			try {
				if(rs != null) rs.close();				
			}
			catch(Exception ignore) {
			}
			
			if(EMS_CONNECTION != null) {
				EMS_CONNECTION.recycleStatement(EMS_STATEMENT);
				EMS_CONNECTION.recycle();	
			}
			
		}
	
	}

	
	
	
	
	public static boolean isFilterPresent(){		
		return INIT_FLAG;
	}
	
	public static void setINIT_FLAG(boolean init_flag) {
		INIT_FLAG = init_flag;
	}

	/**
	 * <br>필터링 될 도메인인지를 판별한다.
	 * <br>유효기간이 지난 것에 대해서는 필터링 대상에서 remove도 해 준다. 
	 * @param domain
	 * @return
	 */
	public synchronized static boolean isTargetDomain( String domain ){
		
		LongDateValue limittime = ( LongDateValue )DOMAIN_HASH.get( domain.toLowerCase() );
		
		if( limittime == null ){
			if(log.isDebugEnabled()){
				log.debug( "[limittime]...[null : return false]");
			}
			return false;
		}
		
		if( limittime.getValue() < System.currentTimeMillis() ){			
			DOMAIN_HASH.remove( domain.toLowerCase() );
			if(log.isDebugEnabled()){
				log.debug( "[limittime]...[time over : return false]");
			}
			return false;
		}
		
		if(log.isDebugEnabled()){
			log.debug( "[limittime]...[return true]");
		}

		return true;
	}
	
	/**
	 * <br>필터링시킬 도메인을 등록한다.
	 * <br>등록시점부터 1일 동안 그 도메인은 필터링된다. 
	 * @param domain
	 */
	public synchronized static void registeFilteringDomain( String domain ){
		
		LongDateValue limittime = ( LongDateValue )DOMAIN_HASH.get( domain );
		if( limittime == null ){
			DOMAIN_HASH.put( domain.toLowerCase() , new LongDateValue( System.currentTimeMillis() + 1000*60*60*24  ) );
		}
		else{
			limittime.setValue( System.currentTimeMillis() + 1000*60*60*24  );
		}
	}
	
	
	/**
	 * <br>필터링시킬 도메인을 등록한다.
	 * <br>act_time 까지 그 도메인은 필터링된다. 
	 * @param domain
	 */
	public synchronized static void registeFilteringDomain(String act_time, String domain ){
		long atime = Long.parseLong(act_time);
		LongDateValue limittime = ( LongDateValue )DOMAIN_HASH.get( domain );
		
		if( limittime == null ){
			DOMAIN_HASH.put( domain.toLowerCase() , new LongDateValue( atime ) );
		}
		else{
			limittime.setValue( atime  );
		}
	}
	
	/**
	 * 필터링 도메인 그룹에서 제외시킨다. 
	 * @param domain
	 */
	public synchronized static void deRegisterFilteringDomain( String domain ){
		DOMAIN_HASH.remove( domain.toLowerCase() );
	}
	
	/**
	 * 필터링 도메인 정보를 String으로 가져온다. 디버그 할 때 사용하면 되겠다.
	 * @return
	 */
	public synchronized static String getInfo(){
		
		StringBuffer buffer = new StringBuffer(512);
		
		for( Enumeration eNum = DOMAIN_HASH.keys() ; eNum.hasMoreElements(); ){
			Object key = eNum.nextElement();
			LongDateValue limittime = ( LongDateValue )DOMAIN_HASH.get( key );
			if( limittime.getValue() < System.currentTimeMillis() ){
				DOMAIN_HASH.remove( key );
			}
			else {
				buffer.append( key.toString() );
				buffer.append( "=" );
				buffer.append( limittime.toString() );
				buffer.append( "," );
			}
		}
		return buffer.toString();
	}
	
	public static void main( String[] arg ) throws Exception{
		
		System.out.println(System.currentTimeMillis());
		
		init( null );
		
		registeFilteringDomain( "amail.co.kr" );
		registeFilteringDomain( "bmail.co.kr" );
		
		
		System.out.println( getInfo() );
		
		Thread.sleep( 1000 );
		
		registeFilteringDomain( "amail.co.kr" );
		
		System.out.println( getInfo() );
		
		deRegisterFilteringDomain( "amail.co.kr" );
		
		System.out.println( getInfo() );
	}
	
	static class LongDateValue {
		long value = 0;
		LongDateValue( long a ){
			setValue( a );
		}
		
		long getValue(){
			return value;
		}
		
		void setValue( long a ){
			value=a;
		}
		
		public String toString(){
			return Cal.getDate( value );
		}
	}
}
