/*
 * RejectFilter.java
 *
 * Created on 2004년 9월 30일 (목), 오후 7:55
 */

package pluto.panopticon.filter;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.Name;

/**삼성화재에서 첨 이슈로 나온녀석임...
 *
 * @author
 */
@Slf4j
public abstract class RejectFilter extends Name {
	
	
	
	
//	private static boolean INIT_FLAG = false;

	private static Class INNER_INSTANCE = null;
	
	/** Creates a new instance of RejectFilter */
	protected RejectFilter() {
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	public static void init( Object tmp ) throws Exception{
		
		Properties prop = ( Properties )tmp;
		
		INNER_INSTANCE = Class.forName( prop.getProperty("filter.class") );
		
		// 클래스가 정상적인지를 일단 알아봐야한다.
		RejectFilter returnValue = ( RejectFilter )INNER_INSTANCE.newInstance();
		
		returnValue.init( new Properties() );
		
		returnValue.destroy();
		
//		INIT_FLAG = true;
	}
	
	public static RejectFilter getFilterInstance( Properties prop ) throws Exception {
		
		RejectFilter returnValue = null;
		
		if( INNER_INSTANCE != null ) {
			returnValue = ( RejectFilter )INNER_INSTANCE.newInstance();
			if( returnValue.init( prop ) ) {
				returnValue = null;
			}
		}
		return returnValue;
	}
	
	/** 진행을 해야하는지 말아야 하는지를 점검한다.
	 * true를 반환하게 되면 필터링을 하지 않는 것이므로 그냥 skip한다.
	 * false 를 반환하게 되면 필터링을 진행한다.
	 */
	protected abstract boolean init( Properties prop ) throws Exception;
	
	public abstract boolean isFiltered( Properties ID ) throws Exception;
	
	public abstract void destroy();
}
