/*
 * ServerStatusInfo.java
 *
 * Created on 2004년 9월 7일 (화), 오후 1:47
 */

package pluto.net.communicator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.schedule.ScheduledMonitor;
/**
 *
 * @author  LENA
 */
@Slf4j
public class ServerStatusInfo extends ScheduledMonitor {
	
	
	private static byte[] SERVER_KEY = new byte[79];
	
	//private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	private static Date myDate = new Date();
	
	private static long REFRESH_CYCLE = 3600*1000L;
	
	private static long CURRENT_REFRESH_TIME = System.currentTimeMillis();
	
	private static Runtime RUNTIME = Runtime.getRuntime();
	
	private static boolean INIT_FLAG = false;
	
	static{
		ServerStatusInfo a = new ServerStatusInfo();
		a.start();
	}
	
	public synchronized static void init( Object tmp ) throws Exception{
		Properties prop = ( Properties ) tmp;
		SimpleDateFormat DATE_FORMAT = null;
		
		byte[] serverkey = prop.getProperty( "server.key" ).getBytes();
		
		if( serverkey.length != 6 ){
			throw new RuntimeException("Server Key Invalid : " + new String( serverkey ) );
		}
		
		System.arraycopy( serverkey , 0 , SERVER_KEY , 0 , 6 );
		
		try{
			REFRESH_CYCLE = Long.parseLong( prop.getProperty( "refresh.cycle" ) );
		}
		catch( Exception e ){
			throw new RuntimeException( "INVALID NUMBER FORMAT : " + prop.getProperty( "refresh.cycle" ) );
		}
		
		try{
			DATE_FORMAT = new SimpleDateFormat( prop.getProperty( "date.format" ) );
		}
		catch( Exception e ){
			DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			throw new RuntimeException( "INVALID DATE FORMAT : " + prop.getProperty( "date.format" ) );
		}
		
		myDate.setTime( System.currentTimeMillis() );
		String start_time = DATE_FORMAT.format( myDate );
		
		byte[] dateformat = start_time.getBytes();
		
		System.arraycopy( dateformat , 0 , SERVER_KEY , 6 , dateformat.length );
		
		INIT_FLAG = true;
	}
	
//	private static long START_TIME = -1;
//	private static long SERVER_TIME = -1;
	
	private static int PUSHED_CNT = 0;
	private static int UPDATE_CNT = 0;
	
	public synchronized static void plusPushedCnt(){
		PUSHED_CNT++;
	}
	
	public synchronized static void plusUpdateCnt(){
		UPDATE_CNT++;
	}
	
	public synchronized static byte[] getStatusInfo(){
		SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		
		if( !INIT_FLAG ){
			return null;
		}
		
		if( CURRENT_REFRESH_TIME > System.currentTimeMillis() - REFRESH_CYCLE ){
			return SERVER_KEY;
		}
		
		myDate.setTime( System.currentTimeMillis() );
		String start_time = DATE_FORMAT.format( myDate );
		
		byte[] dateformat = start_time.getBytes();
		
		System.arraycopy( dateformat , 0 , SERVER_KEY , 26 , dateformat.length );
		
		SERVER_KEY[78] = (byte)'1';
		
		//Write pushed
		if (log.isDebugEnabled())  log.debug( "PUSHED_CNT:" + PUSHED_CNT );
		printInt( PUSHED_CNT  , 46 );
		
		//Write Update
		if (log.isDebugEnabled())  log.debug( "UPDATE_CNT:" + UPDATE_CNT );
		printInt( UPDATE_CNT  , 50 );
		
		//Write DiskTotalSize
		printLong( getDiskTotalSize() , 54 );
		
		//Write DiskUsedSize
		printLong( getDiskUsedSize() , 58 );
		
		//Write DiskFreeSize
		printLong( getDiskFreeSize() , 62 );
		
		//Write MemoryTotal
		printLong( getMemoryTotal() , 66 );
		
		//Write MemoryUsed
		printLong( getMemoryUsed() , 70 );
		
		//Write CPU Rate
		printInt( getCPURate() , 74 );
		
		CURRENT_REFRESH_TIME = System.currentTimeMillis();
		
		// Reset Current Data
		PUSHED_CNT = 0;
		UPDATE_CNT = 0;
		if (log.isDebugEnabled())  log.debug( "UPDATE_CNT:" + new String( SERVER_KEY ) );
		return SERVER_KEY;
	}
	
	private static long getDiskTotalSize(){
		return 0L;
	}
	
	private static long getDiskUsedSize(){
		return 0L;
	}
	
	private static long getDiskFreeSize(){
		return 0L;
	}
	
	private static long getMemoryTotal(){
		return RUNTIME.totalMemory();
	}
	
	private static long getMemoryUsed(){
		return RUNTIME.freeMemory();
	}
	
	private static int getCPURate(){
		return 0;
	}
	
	private static void printInt( int val , int off ){
		/**C 프로그램으로 전송하는 것이므로 배열의 순서를 거꾸로함...
		 *자바에서쓸때 주의해야함
		 */
		SERVER_KEY[off + 0] = (byte) (val >>> 0);
		SERVER_KEY[off + 1] = (byte) (val >>> 8);
		SERVER_KEY[off + 2] = (byte) (val >>> 16);
		SERVER_KEY[off + 3] = (byte) (val >>> 24);
	}
	
	private static void printLong( long _val , int off ){
		/**C 프로그램으로 전송하는 것이므로 배열의 순서를 거꾸로함...
		 *자바에서쓸때 주의해야함
		 */
		int val = (int)(_val / 1024);
		SERVER_KEY[off + 0] = (byte) (val >>> 0);
		SERVER_KEY[off + 1] = (byte) (val >>> 8);
		SERVER_KEY[off + 2] = (byte) (val >>> 16);
		SERVER_KEY[off + 3] = (byte) (val >>> 24);
	}
	
	protected ServerStatusInfo(){
		super( REFRESH_CYCLE , "ServerStatusInfo" );
		//super( 10000000000000L , "ServerStatusInfo" );
	}
	
	/** 상속받은 Class에서 실제적으로 모니터링하는 로직
	 */
	protected void check() throws Exception {
		byte[] aaa = ServerStatusInfo.getStatusInfo();
		if (log.isDebugEnabled())  log.debug( aaa==null?"null null not init...^^":new String( aaa ) );
	}
	
}
