package pluto.net.communicator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.io.TelnetOutputStream;
import pluto.lang.Name;
import pluto.util.Cal;

@Slf4j
public class SendLogFindActor extends Name implements InfoActor{
	
	
	
	public static String act_dir = null;
	public static String log_dir = null;
	public static String os_str = "win";
	
	public static final String space_str = " ";
	public static String log_head = "send_";
	public static String log_tail = ".log";
	
	public static final String chmod_str = "chmod 777";
	
	public static String cmd_cat = "cat";
	public static String cmd_grep = "grep";
	public static String cmd_pipe = " | ";
	
	public static int add_file_cnt = 2;
	public static int max_commu_line_cnt = 1000;
	
	public static int MAX_EXE_CNT = 5;
	public static int NOW_ACT_CNT = 0;
	
	public int send_cnt = 0;
	
	public String thread_name = "";
	
	protected static ArrayList stop_list = new ArrayList();
		
	/**
	 * init 
	 * @param tmp
	 * @throws Exception
	 */
	public static void init( Object tmp ) throws Exception {
		Properties prop = ( Properties )tmp;
		
		// os 구분
		os_str = prop.getProperty("os.str");
		
		if(os_str.equals("win")){
			// util과 bat파일이 생성될 dir
			act_dir = separatorReplace(prop.getProperty("grep.dir"),"/");
			// log파일이 있는 dir
			log_dir = separatorReplace(prop.getProperty("log.dir"),"/");
			
			cmd_cat =  act_dir+File.separator+"cat ";
			cmd_grep =  act_dir+File.separator+"grep ";
		}else{
			//util과 bat파일이 생성될 dir
			act_dir = prop.getProperty("grep.dir");
			// log파일이 있는 dir
			log_dir = prop.getProperty("log.dir");
			
			cmd_cat =  "cat ";
			cmd_grep = "grep ";
		}
		
		// log 구분 head 
		log_head = prop.getProperty("log.head");
		// log 구분 tail 
		log_tail = prop.getProperty("log.tail");
		// 같이 조회할 파일의 갯수 
		add_file_cnt = Integer.parseInt( prop.getProperty("add.file.cnt") );
		// 조회값의 최대 출력 라인 - 무한히 많은 정보가 나오게 될 경우를 위해서 지정함. 
		max_commu_line_cnt = Integer.parseInt( prop.getProperty("max.commu.line") );
		
		MAX_EXE_CNT = Integer.parseInt( prop.getProperty("max.exe.cnt") );
		
		cmd_pipe = " | "; 
	} 
	
	
	
	
	public void setThreadName(String name){
		this.thread_name = name;
		
	}
	
	public boolean stopYN(){
		return stop_list.contains(this.thread_name);
	}	
	public void removeThreadName(){
		stop_list.remove(this.thread_name);
	}	
	
	
	public SendLogFindActor(){
		this.setName( "SendLogFindActor" + Cal.getSerialDate() );
	}	
	
	/**
	 * 기본 실행 메소드 : 여기서는 오버로드해서 사용한다.
	 */
	public void execute(InfoBeans arg) throws Exception {		
	}
	
	
	/**
	 * 통신이 진행되면 실행되는 메소드
	 * @param arg : 통신시 web에서 전달된 parameter
	 * @param SMTP_BINARY_OUTSTREAM : web과 통신을 진행중인 체널
	 */
	public void execute(InfoBeans arg,TelnetOutputStream SMTP_BINARY_OUTSTREAM) throws Exception {
		
		log.info("[execute]...[start]" );		
		log.info("[THREAD NAME]...["+this.thread_name+"]" );
		
		Properties prop = arg.getArgs();
		
		send("[NOW_ACT_CNT]"+NOW_ACT_CNT,SMTP_BINARY_OUTSTREAM);
		if(NOW_ACT_CNT>MAX_EXE_CNT){
			prop.setProperty("RESULT", "[act]over act user=>[max:"+MAX_EXE_CNT+"]");
			return;
		}
		
		if(this.stopYN()){
			prop.setProperty("RESULT", "[act]stop order command - excute front");
			return;
		}
		
		String grep_key = prop.getProperty("USER_ID","test")+System.currentTimeMillis();
		
		
		String srh_word = prop.getProperty("SRH_WORD");
		String srh_word2 = prop.getProperty("SRH_WORD2"); // garden79
		String start = prop.getProperty("START");
		String end = prop.getProperty("END");
		StringBuffer bat_buffer = new StringBuffer();
		String bat_file = "";
		String msg = "";
		BufferedWriter out = null;
		
		StringBuffer search_files = new StringBuffer();
				
		// get file list 
		ArrayList file_list = file_list(start, end);
		// list파일이 없다면 그냥 없음을 리턴한다.
		if(file_list==null){
			prop.setProperty("RESULT", "[act]log_file not found:"+start+"~"+end);
			return;
		}	
		
		//add_file_cnt
		int file_list_size = file_list.size();
		
		for(int i=0; i<file_list_size; i++){
			log.debug( "[NOW_ACT_CNT]"+NOW_ACT_CNT+"[I]"+i);
			
			//buffer 초기화
			//add cat
			if(i%add_file_cnt==0){
				bat_buffer.setLength(0);
				bat_buffer.append(cmd_cat);
				bat_buffer.append(log_dir+File.separator+(String)file_list.get(i)+" ");
				
				search_files.setLength(0);
				search_files.append((String)file_list.get(i));
			}else{
				bat_buffer.append(log_dir+File.separator+(String)file_list.get(i)+" ");
				search_files.append(" "+(String)file_list.get(i));
			}
			
			//add grep
			if( i%add_file_cnt==(add_file_cnt-1) || (i==file_list_size-1) ){
				bat_buffer.append(cmd_pipe);
				bat_buffer.append(cmd_grep);
				bat_buffer.append(" \""+srh_word.trim()+"\"");
				
				if(!srh_word2.equals("")){ // 성공여부 / 에러코드 조회값이 존재하면 수행함.
					bat_buffer.append(cmd_pipe);
					bat_buffer.append(cmd_grep);
					bat_buffer.append(" \""+srh_word2.trim()+"\"");
				}
				
				//JOO make bat file
				if(os_str.equals("win")){
					bat_file = act_dir+File.separator+grep_key+"_"+System.currentTimeMillis()+".bat";
				}else{
					bat_file = act_dir+File.separator+grep_key+"_"+System.currentTimeMillis()+".sh";
				}
				
				if (log.isDebugEnabled()) {
					log.debug("[bat==>]"+bat_buffer.toString() );
				}
								
				try {				
					out = new BufferedWriter(new FileWriter(bat_file));					
					out.write(bat_buffer.toString());
					out.newLine();
				}catch(Exception e) {
					log.error("Exception", e);
				}finally {
					out.close();
				}
											
				send(" ",SMTP_BINARY_OUTSTREAM);
				send("***** [FILE]"+search_files.toString()+" *****",SMTP_BINARY_OUTSTREAM);
				//JOO communication web --------------------------
				msg = commuRuntime(bat_file,SMTP_BINARY_OUTSTREAM);
				//------------------------------------------------

				log.debug("[SCRIPT]"+bat_buffer.toString() );
				log.debug("[SEND_CNT]"+send_cnt );
				
				//JOO delete bat file
				File act_bat = new File(bat_file);
				boolean fileDel = act_bat.delete();
				if(!fileDel) log.error("File deletion failed");
				if (log.isDebugEnabled()) {
					log.debug("[delete bat==>]"+bat_file );
				}
				
				if(send_cnt>max_commu_line_cnt || this.stopYN()){
					if(this.stopYN()){
						prop.setProperty("RESULT", "[act]stop order command - loof file list "+msg);
					}else{
						prop.setProperty("RESULT", "[act]over max line=>[max:"+max_commu_line_cnt+"] "+msg);
					}
					return;
				}
				
			}
		}
		
		// 작업이 끝났으므로 해당 thread name을 list에서 삭제한다.
		if(this.stopYN()){
			removeThreadName();
		}
		
		prop.setProperty("RESULT", "[act]complate");		
		log.debug("[execute]...[end]" );
	}
	
	/**
	 * TelnetOutputStream 으로 내용 전달
	 * @param source
	 * @param SMTP_BINARY_OUTSTREAM
	 * @throws IOException
	 */
	protected void send(String source,TelnetOutputStream SMTP_BINARY_OUTSTREAM) throws IOException {
		if( source == null )
			return;

		if( source.length() == 0 ) {
			SMTP_BINARY_OUTSTREAM.writeln();
		}
		else {			
			SMTP_BINARY_OUTSTREAM.write(source);
			SMTP_BINARY_OUTSTREAM.writeln();
			if (log.isDebugEnabled())  log.info("[COMMU_RESULT]" + source);
		}
	}
	
	
	/**
	 * 해당 cmd를 실행하는 메소드로 라인을 출력하면서 통신으로 web에 라인을 send 한다.
	 * @param send_cnt
	 * @param cmd
	 * @param SMTP_BINARY_OUTSTREAM
	 */
	protected String commuRuntime(String cmd, TelnetOutputStream SMTP_BINARY_OUTSTREAM){
		
		if(send_cnt>max_commu_line_cnt || this.stopYN()){			
			if(this.stopYN()){
				return "stop order front commuRuntime";
			}else{
				return "over send_cnt";
			}			
		}
		
		Process process = null;		
		try {
			// unix 일경우 생성된 shell 파일의 실행권한이 없다. 
			//때문에 shell파일에 실행권한을 주는 부분이다.
			if(!os_str.equals("win")){//nt 가 아닐경우 실행
				String chmod_exe = chmod_str+space_str+cmd;
				process = Runtime.getRuntime().exec(chmod_exe);
				log.debug(  "[chmod_str ==>]"+chmod_exe );
				process.waitFor();
			}
			
			// 액션 파일을 실행한다.
			process = Runtime.getRuntime().exec(cmd);
			
			BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
			String line = null;
			
			while ((line = br.readLine()) != null) {
				if(line.indexOf("Cat ") >= 0 || line.indexOf("cat ") >= 0){
					// 명령라인은 skip
					continue;
				}else{
					//To web
					send(line,SMTP_BINARY_OUTSTREAM);
					send_cnt++;
					//최대출력라인보다 초과되면 그냥 나간다.
					if(send_cnt>max_commu_line_cnt || this.stopYN()){						
						if(this.stopYN()){
							return "stop order sending";
						}else{
							return "over send_cnt";
						}						
					}
				}
			}  
			
		} catch (Exception e) {
			System.err.println(e);
		}
		
		return "complate";		
	}
	
	
	/**
	 * start와 end 사이의 index를 가진 파일을 arraylist로 리턴한다.(start,end 포함)
	 * @param start
	 * @param end
	 * @return
	 */
	protected ArrayList file_list(String start, String end){
		int s_time = Integer.parseInt(start);
		int e_time = Integer.parseInt(end);
		
		if(s_time>e_time){
			return null;
		}
		
		Calendar cal = Calendar.getInstance();
		int year,month,date,hour;
		
		year = (s_time)/1000000;
		month = ((s_time)%1000000)/10000-1;
		date = ((s_time)%10000)/100;
		hour = (s_time)%100;
		cal.set(year, month, date, hour, 0);
		
		ArrayList fileList = new ArrayList();
		int yyyymmddhh = s_time;
		File log_file = null;
		String log_name = "";
		
		
		while(e_time >= yyyymmddhh){		
			log_name = log_head+yyyymmddhh+log_tail;
			log_file = new File(log_dir+File.separator+log_name);
			
			if(log_file.exists()){				
				fileList.add(log_name);
				if (log.isDebugEnabled())  log.debug("[yyyymmddhh]" + yyyymmddhh);
			}			
			yyyymmddhh = change_date(cal, 1);
		}		
		
		return fileList;
	}
	
	/**
	 * 특정 calendar에서 shour를 더한 후의 calendar에서 int yyyymmddhh 로 반환
     * @param cal start_date.
     * @param shour add_hour.
     * @return int yyyymmddhh
     */
	public static int change_date(Calendar cal, int shour) {
		Calendar ch_day = cal;
		
		//원하는 시간만큼 더하거나 빼는 부분.
		if(shour != 0){
			ch_day.add(Calendar.HOUR_OF_DAY,shour);			
		}
		
		int year = ch_day.get(Calendar.YEAR);
		int month = ch_day.get(Calendar.MONTH) + 1;
		int day = ch_day.get(Calendar.DATE);
		int hour = ch_day.get(Calendar.HOUR_OF_DAY);
		
		return (year*1000000)+(month*10000)+(day*100)+(hour);
	}
	
	public static String separatorReplace(String path, String tag){
		String path_str = path;
		int point = 0;
		
		while(path_str.indexOf(tag)>=0){
			point = path_str.indexOf(tag);
			path_str = path_str.substring(0, point)+File.separator+path_str.substring(point+1);
		}
		
		return path_str;
	}
}




