package pluto.net.communicator;

import com.humuson.tms.common.util.PushResponseConverToCodeUtil;
import com.humuson.tms.constrants.CommonType;
import com.humuson.tms.mq.model.MgsPush;

import lombok.Data;

@Data
public class MqResponseParseBean {

//	private long pushId;
	private long deviceId;
	private String reqUid;
	private String custId;
	private CommonType sendType;
	private String listTableName;
	private String postId;
	private String returnCode;
	private String serverId;
	private boolean isSuccess = false; 
	private boolean isDeliver = false;
	
	private final String AUTO_TABLE_PREFIX = "TMS_AUTO_SEND_LIST_";
	private final String CAMP_TABLE_PREFIX = "TMS_CAMP_SEND_LIST_";
	
	
	public MqResponseParseBean() {
		
	}
	
	public MqResponseParseBean(MgsPush.Response.ResponsePayload payload) throws Exception {
		parse(payload);
	}
	
	public void parse(MgsPush.Response.ResponsePayload payload) throws Exception {
		//pushQueue.getPushId()+"&&"+pushQueue.getDeviceId()+"&&"+pushQueue.getReqUid()+"&&"+pushQueue.getCustId();
		String splitId[] = payload.getId().split("&&");
//		44648600_3000001_AA20170112_8^sgeom_25916331

		if (splitId.length <= 2 || splitId.length >= 5) {
			throw new Exception("MqResponseParseBean ResponsePayload.getId parse ERROR! length range out(splitId.length <= 2 || splitId.length >= 5) payload.getId() :" + payload.getId());
		}
		
//		pushId = Long.parseLong(splitId[0]);
		deviceId = Long.parseLong(splitId[1]);
		reqUid = splitId[2];
		
		if(reqUid.startsWith("AA")){
			//"AT"+postId+"^"+memberId+"|"+list_table_num+"-"+sUniKey) (테스트 발송)
			//AA"+postId+"^"+memberId+"|"+list_table_num
			//AA20140207_6^39703465|01-123
			sendType = CommonType.AUTO;
			listTableName = AUTO_TABLE_PREFIX + reqUid.split("\\|")[1];
			postId = reqUid.split("\\^")[0].replace("AA", "");
			custId = reqUid.split("\\^")[1].split("\\|")[0];
		}else if(reqUid.startsWith("CC")){
			//"CT"+postId.substring(0, 13)+"^"+memberId+"-"+sUniKey (테스트 발송)
			//"CC"+postId.substring(0, 13)+"^"+memberId	
			//CC+POST_ID^MEMBER_ID
			//CC2014022100001^123
			sendType = CommonType.CAMP;
			listTableName = CAMP_TABLE_PREFIX + reqUid.substring(6, 8);
			postId = reqUid.substring(2,15);
			if(splitId.length == 4){
				custId = splitId[3];
			}
		}else if(reqUid.startsWith("CT") || reqUid.startsWith("AT") ){
			sendType = CommonType.TEST;
		}
		
		serverId = payload.getServerId();
		returnCode =	PushResponseConverToCodeUtil.responseToResponseCode(String.valueOf(payload.getReturnCode().getNumber()));
		
		if(MgsPush.Response.ReturnCode.SUCCESSFUL.equals(payload.getReturnCode())
				|| MgsPush.Response.ReturnCode.SENDING.equals(payload.getReturnCode())
				|| MgsPush.Response.ReturnCode.SENDING_CCS.equals(payload.getReturnCode())){
			isSuccess = true;
		} else if ( MgsPush.Response.ReturnCode.XMPP_DELIVER.equals(payload.getReturnCode()) ) {
			isDeliver = true;
		}
		
//		if(MgsPush.Response.ReturnCode.SENDING.equals(payload.getReturnCode()) ||
//				MgsPush.Response.ReturnCode.SENDING_CCS.equals(payload.getReturnCode())){
//			
//		}
	}
	
	public void clear(){
//		pushId = -1;
		deviceId = -1;
		reqUid = null;
		custId = null;
		sendType = null;
		listTableName = null;
		postId = null;
		returnCode = null;
		isSuccess = false;
		isDeliver = false;
	}
	
	
}
