/*
 * MonitorWorker.java
 *
 * Created on 2004년 9월 7일 (화), 오전 11:54
 */

package pluto.net.communicator;

import java.net.Socket;

import lombok.extern.slf4j.Slf4j;
import pluto.net.SocketInputStreamAgent;

/**
 *
 * @author  t??
 */
@Slf4j
public class MonitorWorker extends SocketInputStreamAgent implements Runnable{
	private static final int __CONNECTION_DELAY__ = 360*1000;
	
	ThreadGroup __REGIST_THREAD_GROUP__ = null;
	Socket __SOURCE_SOCKET__ = null;
	/** Creates a new instance of MonitorWorker */
	public MonitorWorker( ThreadGroup group , String name , Socket mySocket ) {
        super( true );
        setName( name );
        this.__REGIST_THREAD_GROUP__ = group;
        this.__SOURCE_SOCKET__ = mySocket;
	}
    
    /** 실제적으로 Worker를 구동한다.
     * @throws Exception 내부 Thread를 생성하는 곳까지 throw 되는 Exception
     */
    public void start() throws Exception {
        connect( this.__SOURCE_SOCKET__ );
        setConnectionTimeout( __CONNECTION_DELAY__ );
        
        Thread inner_thread = new Thread( this.__REGIST_THREAD_GROUP__ , this , getName() );
        inner_thread.start();
    }
	
	public void run() {
        try {
            work();
        }
        catch( Exception e ) {
            log.debug( "CommunicationError" , e );
        }
        finally {
            try{ this.close(); }catch( Exception e ){}
            try{ super.unregist(); }catch( Exception e ){}
        }
	}
	
    
    /** 세부 작업을 정의
     * @throws Exception 주로 네트웍오류나 작업시 발생하는 Exception
     */
    public void work() throws Exception {
		send( ServerStatusInfo.getStatusInfo() );
	}
}
