/*
 * MonitorServerActivator.java
 *
 * Created on 2004년 9월 7일 (화), 오전 11:52
 */

package pluto.net.communicator;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
/**
 *
 * @author  t??
 */
@Slf4j
public class MonitorServerActivator extends Thread {
	protected static int _LISTENER_PORT_ =0;
	protected static int _QUE_SIZE_ = 0;
	
	public static void init( Object tmp ) throws Exception {
		Properties prop = ( Properties )tmp;
		
		_LISTENER_PORT_ = Integer.parseInt( prop.getProperty("listener.port") );
		_QUE_SIZE_ =  Integer.parseInt( prop.getProperty("listener.quesize"));
	}
	
	/** Creates new CommunicationServerActivator */
	public MonitorServerActivator() throws Exception{
		s_socket = new ServerSocket( _LISTENER_PORT_ , _QUE_SIZE_ );
	}
	
	private ServerSocket s_socket = null;
	
	public void run() {
		log.debug("TCP SERVER START");
		while( true ) {
			try {
				Socket ReceiveSocket = s_socket.accept();
				MonitorWorker myWorker = new MonitorWorker( pluto.lang.eMsLocale.EMS_ROOT_THREAD_GROUP , "Actor#".concat( ReceiveSocket.getInetAddress().getHostAddress() ).concat("@").concat( String.valueOf( System.currentTimeMillis() ) ) , ReceiveSocket );
				myWorker.start();
			}
			catch( Exception e ) {
				log.error("error", e);
				try{ Thread.currentThread().sleep( 10000 ); }catch( Exception ex ){}
			}
		}
	}
}
