package pluto.net.communicator;

import java.util.Hashtable;
import java.util.Properties;

import pluto.lang.Name;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;

/**
 * 아직 미완성임. 나중에 처리할 예정임.
 * @author JOO
 *
 */
@Slf4j
public class MailSendStopActor extends Name implements InfoActor{
	
	private static Hashtable<String, String> SEND_STOP_HASH = null;
	
	
	
	
	static {
		SEND_STOP_HASH = new Hashtable<String, String>();
	}
	
	/**
	 * stop hash에 내역이 있는지 확인
	 * @param post_id
	 * @return
	 */
	public static boolean doStop(String post_id){
		if(SEND_STOP_HASH.containsKey(post_id)){
			
			//멈추기 위해서 true를 전달한다.
			return true;
		}
		
		return false;
	}
	
	/**
	 * 엔진이 응답을 받았다는 것을 표시하기 위해 사용
	 * @param post_id
	 * @return
	 */
	public static boolean isStop(String post_id){
		if(SEND_STOP_HASH.containsKey(post_id)){
			
			SEND_STOP_HASH.put(post_id,"STOP_OK");
			//멈추기 위해서 true를 전달한다.
			return true;
		}
		
		return false;
	}	

	
	
	public MailSendStopActor(){
		this.setName( "MailSendStopActor" + Cal.getSerialDate() );
	}
	
	
	public void execute(InfoBeans arg) throws Exception {
		String result = "";
		
		
		Properties prop = arg.getArgs();
		
		String post_id = prop.getProperty("POST_ID");
		String act     = prop.getProperty("ACT");
		
		if(log.isDebugEnabled()){
			log.debug("[POST_ID] :"+post_id );
		}
		
		// 이미 존재한다면 작업중임을 알림
		if(SEND_STOP_HASH.containsKey(post_id)){
			result = "working";
		}else{
			// 액션을 넣는다.
			SEND_STOP_HASH.put(post_id, act);
			
			long act_time = System.currentTimeMillis();
			
			String ok_flag = act+"_OK";
			
			//엔진이 확인 할때까지 대기한다.
			while (true) {
				if(SEND_STOP_HASH.get(post_id).equals(ok_flag)){
					result = "OK";
					
					//완료됐기 때문에 삭제한다.
					SEND_STOP_HASH.remove(post_id);
					
					continue;
				}
				
				if(System.currentTimeMillis()-act_time > 10000){
					result = "TIME_OUT";
					continue;
				}
			}
		}
		
		prop.setProperty("RESULT", result);
	}
}