package pluto.net.communicator;

import java.util.Properties;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

import org.apache.activemq.ActiveMQConnectionFactory;

import com.google.protobuf.InvalidProtocolBufferException;
import com.humuson.tms.constrants.CommonType;
import com.humuson.tms.mq.model.MgsPush;
import com.humuson.tms.mq.model.MgsPush.Response;

import lombok.extern.slf4j.Slf4j;
import pluto.log.Composer;
import pluto.log.SmtpLogger;
import pluto.util.Cal;
import pluto.util.convert.DelimConvertor;

@Slf4j
public class MQConsumer extends Thread {
	
	private ConnectionFactory factory 	= null;
	private Connection connection 		= null;
	private Session session 			= null;
	private Destination destination 	= null;
	private MessageConsumer consumer 	= null;
	
	// AT INFO
//	private	MsgProducer realtimeReportProducer 	= null;
	
	private String 	brokerUrl 			=	"";
	
	private String 	sendQueName 		=	"";

	private String 	responseMQname 	=	"";

	private String 	msgType 			=	"";
	
	private Properties PROP 			=	new Properties();
	
	protected Composer	composer		= null;
	
	protected StringBuffer			TMP_BUFFER					=  new StringBuffer(256);
	
	private String engType;
	
	
	public MQConsumer(Properties prop) {
		
		// 로그 조립 인스턴스 초기화
		this.composer = Composer.getComposerInstance();
		
		if(prop != null){
			this.PROP 			= (Properties)prop;
			this.brokerUrl 		= prop.getProperty("BROKER_URL");
			this.responseMQname = prop.getProperty("RESPONSE_MQ_NAME");
			this.engType = prop.getProperty("ENG_TYPE");
			
			init();
			
		}
		
	}

	public void run() {
		
		try {
			
			consumer = session.createConsumer(destination);
			Message message = null;
			MgsPush.Response response;
			MqResponseParseBean resParseBean = new MqResponseParseBean();
			byte[] data = null;
			while(true){
				try{
					resParseBean.clear();
					// send queue receive...
					message = consumer.receive();
					if (message instanceof BytesMessage) {
						BytesMessage byteMessage = (BytesMessage) message;
						data = new byte[(int) byteMessage.getBodyLength()];
						byteMessage.readBytes(data);
						response = parseByteMessage(data);
						
						
						for (MgsPush.Response.ResponsePayload payload : response.getResPayloadList()){
							try{
								resParseBean.parse(payload);
								loggingResponse(resParseBean);
							}catch (Exception e){
								log.error("ResponsePayload parse Error : {}",e);
							}
						}
							
					}
					
				}catch(InvalidProtocolBufferException parseException){
					log.error("MgsPush parse error! Pass this data : {}, Error : {} ",data, parseException);
					continue;
				}catch(JMSException jmsException){
					log.error("JMSException consume receive error {}", jmsException);
				}
				
			}
		} catch (JMSException e){
			log.error("JMSException createConsumer Error  : {}" ,e);
		}finally {
			release();
		}
	}
	
	
	
	
	
	public void init(){
		try{
			factory = new ActiveMQConnectionFactory(brokerUrl);
			connection = factory.createConnection();
			connection.start();
			session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
			destination = session.createQueue(responseMQname);
			
			log.debug("[MQ CONN SUCCESS] : "+responseMQname);
			
		}catch(Exception e){
			log.error("[MQ CONN fail] : {}", responseMQname+" error "+e);
		}
	}
	
	public void release() {
		try{
			
			if(connection != null){
				log.debug("connetion close ..."+responseMQname);
				connection.close();
			}
			if(session != null){
				session.close();
				log.debug("session close ..."+responseMQname);
			}
		}catch(Exception e){
			log.error("consumer resource close Error : {}", e);
		}
	}
	
	
	protected void loggingResponse(MqResponseParseBean resParseBean) throws Exception {
		// 상태값 업데이트
		if(CommonType.TEST.equals(resParseBean.getSendType())){
			return;
		}
		
		synchronized (this.composer.getLock()) {
			this.composer.setProperty(pluto.log.Log.LOG_SEND_TYPE, resParseBean.getSendType().toString());
			this.composer.setProperty(pluto.log.Log.LOG_SERVER_ID, resParseBean.getServerId());
			if(resParseBean.isSuccess()){
				// 성공 TYPE 값  성공코드이거나 private_server 발송중 이거나 CCS 발송중이면 성공
				this.composer.setProperty(pluto.log.Log.LOG_T_TYPE, "54");
				this.composer.setProperty(pluto.log.Log.LOG_ETC_LOG, "Receive MQ PushResponse ACK");
			} else if (resParseBean.isDeliver()) {
				// upstream TYPE 값. 56은 임의의 값
				this.composer.setProperty(pluto.log.Log.LOG_T_TYPE, "56");
				this.composer.setProperty(pluto.log.Log.LOG_ETC_LOG, "Receive MQ Push UpStream");
			} else{
				// 실패 TYPE 값
				this.composer.setProperty(pluto.log.Log.LOG_T_TYPE, "55");
				this.composer.setProperty(pluto.log.Log.LOG_ETC_LOG, "Receive MQ PushResponse NACK");
			}
			
			this.composer.setProperty(pluto.log.Log.LOG_T_CODE, resParseBean.getReturnCode());
			this.composer.setProperty(pluto.log.Log.LOG_MAIL_ID, resParseBean.getPostId());

			// 회원아이디는 구분자 인코딩을 하여 추가한다.
			this.TMP_BUFFER.setLength(0);
			DelimConvertor.encodeToBuffer(this.TMP_BUFFER, resParseBean.getCustId());
			this.composer.setProperty(pluto.log.Log.LOG_MEMBER_ID, this.TMP_BUFFER.toString());
			
			//해당 값은 Response로부터 값을 받지않음으로 공백로 설정함.
			this.composer.setProperty(pluto.log.Log.LOG_ROWID, "");	// add TMS3.0 ROWID

			//해당 값은 Response로부터 값을 받지않음으로 0으로 일단 설정함.
			this.composer.setProperty(pluto.log.Log.LOG_STEP, "0");
			this.composer.setProperty(pluto.log.Log.LOG_T_DATE, Cal.getDate());
			//해당 값은 Response로부터 값을 받지않음으로 공백로 설정함. 또한 푸시와 무관한 값임.
			this.composer.setProperty(pluto.log.Log.LOG_MX_RECORD, "");
			// 일단 딜레이도 0으로 설정
			this.composer.setProperty(pluto.log.Log.LOG_DELAY, String.valueOf("0"));
			//해당 값은 Response로부터 값을 받지않음으로 공백로 설정함.
			this.composer.setProperty(pluto.log.Log.LOG_TOKEN_ID, "");
			//해당 값은 Response로부터 값을 받지않음으로 공백로 설정함. 또한 푸시와 무관한 값임.
			this.composer.setProperty(pluto.log.Log.LOG_DOMAIN, "");
			this.composer.setProperty(pluto.log.Log.LOG_WORKER, getName());
			this.composer.setProperty(pluto.log.Log.LOG_LIST_TABLE, resParseBean.getListTableName());
//			this.composer.setProperty(pluto.log.Log.LOG_ETC_LOG, "Receive MQ PushResponse");

			SmtpLogger.put(this.composer);
		}
		
	}
	
	public Response parseByteMessage(byte[] bytes) throws InvalidProtocolBufferException {
			return MgsPush.Response.parseFrom(bytes);
	}
	
	public static void main(String[] args) {
		Properties prop = new Properties();
		
		long reqtm = Long.parseLong("2016-07-21 17:19:39");
		long restm = Long.parseLong("2016-07-21 17:19:41");
	}
}