/*
 * InfoComunicator.java
 *
 * by joo
 */

package pluto.net.communicator;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.io.BASE64DecodeOutputStream;
import pluto.io.BASE64EncodeOutputStream;
import pluto.lang.eMsLocale;
import pluto.net.SocketReaderAgent;
/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public class LogComunicator extends SocketReaderAgent {
	private static final int __CONNECTION_DELAY__ = 180*1000;
	
	private static byte[] KEY_HEADER = null;
	private static String KEY_HEADER_STRING = null;
	private static byte[] KEY_ENDING_POINT = null;
	private static byte[] KEY_NEWLINE = null;
	private static String THREAD_NAME_STRING = null;
	
	protected static Object __LOCK_OF_BUFFER__ = new Object();
	
	private BufferedWriter out = null;
	
	private String thread_name = "";
	
	static{
		KEY_HEADER_STRING = "##";
		KEY_HEADER = KEY_HEADER_STRING.getBytes();
		KEY_NEWLINE = "\r\n".getBytes();
		KEY_ENDING_POINT = ".".getBytes();
		THREAD_NAME_STRING = "@@";
	}
	
	InfoBeans beans = null;
	
	protected int CONNECTION_DELAY = __CONNECTION_DELAY__;
	
	/**넘겨줄 빈즈를 바이트로 바꿔서 다시 인코딩을 한다.
	 */
	protected ByteArrayOutputStream __OUT_BUFFER__ = null;
	protected BASE64EncodeOutputStream __ENCODED_OUT_BUFFER__ = null;
	protected BASE64DecodeOutputStream __DECODED_OUT_BUFFER__ = null;
	
	/** Creates new InfoComunicator */
	public LogComunicator(BufferedWriter out) {
		super( false );
		setName( "InfoComunicator" );
		__OUT_BUFFER__ = new ByteArrayOutputStream( 1024 );
		__ENCODED_OUT_BUFFER__ = new BASE64EncodeOutputStream( __OUT_BUFFER__ , 1024 );
		__DECODED_OUT_BUFFER__ = new BASE64DecodeOutputStream( __OUT_BUFFER__ , 1024 );
		
		this.out = out;
	}
	
	/** Creates new InfoComunicator */
	public LogComunicator() {
		super( false );
		setName( "InfoComunicator" );
		__OUT_BUFFER__ = new ByteArrayOutputStream( 1024 );
		__ENCODED_OUT_BUFFER__ = new BASE64EncodeOutputStream( __OUT_BUFFER__ , 1024 );
		__DECODED_OUT_BUFFER__ = new BASE64DecodeOutputStream( __OUT_BUFFER__ , 1024 );
	}
	
	public void setLimitTime( int time ){
		CONNECTION_DELAY = time;
	}
	
	public void setInfoBeans( InfoBeans arg ) {
		this.beans = arg;
	}
	
	public InfoBeans execute() throws Exception {
		if( this.beans == null ) {
			throw new RuntimeException("InfoBean is not set!");
		}
		
		String body = null;
		
		__ENCODED_OUT_BUFFER__.flush();
		__OUT_BUFFER__.reset();
		
		for( Enumeration eNum = this.beans.propertyNames() ; eNum.hasMoreElements() ; ){
			String key = ( String )eNum.nextElement();
			
			__OUT_BUFFER__.write( KEY_HEADER );
			__OUT_BUFFER__.write( key.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET) );
			__OUT_BUFFER__.write( KEY_NEWLINE );
			
			__ENCODED_OUT_BUFFER__.write( this.beans.getProperty( key ).getBytes() );
			__ENCODED_OUT_BUFFER__.flush();
			
			__OUT_BUFFER__.write( KEY_NEWLINE );
			__OUT_BUFFER__.write( KEY_NEWLINE );
			__OUT_BUFFER__.flush();
		}
		
		__OUT_BUFFER__.write( KEY_NEWLINE );
		__OUT_BUFFER__.write( KEY_ENDING_POINT );
		__OUT_BUFFER__.flush();
		
		body = __OUT_BUFFER__.toString();
		
		
		try {
			connect( this.beans.getServerIP() , this.beans.getServerPORT() );
			setConnectionTimeout( CONNECTION_DELAY );
			
			// 초기 OK SIGN 받기
			String message = receive();
			
			if( message == null ) {
				throw new RuntimeException( "WELCOME MESSAGE IS NULL");
			}
			
			if( !message.equalsIgnoreCase("OK") ) {
				throw new RuntimeException( "SERVER RETURN INVALID MESSAGE[" + message + "]");
			}
			
			super.send( "actor" );
			
			/** 
			 * 빈즈를 스트링으로 변환한 것을 전송한다.
			 */
			super.send( body );
			
			/**
			 * 결과로 넘어오는 빈즈를 받는다.
			 */
			while( true ) {
				message = super.receive();
				
				if( message == null || message.equals( "." ) ) {
					break;
				}
				
				if( message.length() < 1 ){
					continue;
				}
				
				/**
				 * 프로퍼티 키가 나온다면.
				 */
				if( message.startsWith( KEY_HEADER_STRING ) ){
					String key = message.substring( KEY_HEADER_STRING.length() );
					__DECODED_OUT_BUFFER__.flush();
					__OUT_BUFFER__.reset();
					while( true ){
						message = super.receive();
						
						if( message == null || message.length() < 1 ) {
							break;
						}
						__DECODED_OUT_BUFFER__.write( message.getBytes() );
					}
					__DECODED_OUT_BUFFER__.flush();
					__OUT_BUFFER__.flush();
					
					this.beans.setProperty( key , __OUT_BUFFER__.toString( eMsLocale.CHAR_SET ) );
					
				}else if( message.startsWith( THREAD_NAME_STRING ) ){
					this.setThread_name(message.substring( THREAD_NAME_STRING.length() ));
					
				}else if(out!=null){
					//JOO web에서 사용
					out.write(message);
					out.newLine();
					out.flush();
					if (log.isDebugEnabled()) {
						log.debug(message);
					}
				}else{
					if (log.isDebugEnabled()) {
						log.debug(message);
					}
				}
			}	
			return this.beans;
		}
		catch( Exception e) {
			throw e;
		}
		finally {
			try{ super.close(); }catch( Exception e ){}
			try{ super.unregist(); }catch( Exception e ){}
		}
	}
	
	public String getThread_name() {
		return thread_name;
	}

	public void setThread_name(String thread_name) {
		this.thread_name = thread_name;
	}

	public static void main( String[] arg ) throws Exception{
		InfoBeans scontent = new InfoBeans();
		
		Properties prop = new Properties();
		
		prop.setProperty( "USER_ID" , "leejc297");
		prop.setProperty( "SRH_WORD" , "gon0911@gmail.com");
		prop.setProperty( "START" , "2008050111");
		prop.setProperty( "END" , "2008050123");
		

		scontent.setArgs( prop );
		scontent.setHandler( "pluto.net.communicator.SendLogFindActor" );
		scontent.setServerIP("127.0.0.1");
		scontent.setServerPORT(Integer.parseInt("9998"));
	
		LogComunicator tester = new LogComunicator();
	
		tester.setInfoBeans(scontent);
	
		scontent = tester.execute();
	
		String member_content = scontent.getProperty( "RESULT" );
		
		System.out.println(member_content);
		
		System.exit( 0 );
	}	
}
