/*
 * InfoComunicator.java
 *
 * Created on 2003년 4월 17일 목, 오후 4:29
 */

package pluto.net.communicator;

import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.io.BASE64DecodeOutputStream;
import pluto.io.BASE64EncodeOutputStream;
import pluto.lang.eMsLocale;
import pluto.net.SocketReaderAgent;
/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public class InfoComunicator extends SocketReaderAgent {
	private static final int __CONNECTION_DELAY__ = 180*1000;
	
	private static byte[] KEY_HEADER = null;
	private static String KEY_HEADER_STRING = null;
	private static byte[] KEY_ENDING_POINT = null;
	private static byte[] KEY_NEWLINE = null;
	
	protected static Object __LOCK_OF_BUFFER__ = new Object();
	
	static{
		KEY_HEADER_STRING = "##";
		KEY_HEADER = KEY_HEADER_STRING.getBytes();
		KEY_NEWLINE = "\r\n".getBytes();
		KEY_ENDING_POINT = ".".getBytes();
	}
	
	InfoBeans beans = null;
	
	protected int CONNECTION_DELAY = __CONNECTION_DELAY__;
	
	/**넘겨줄 빈즈를 바이트로 바꿔서 다시 인코딩을 한다.
	 */
	protected ByteArrayOutputStream __OUT_BUFFER__ = null;
	protected BASE64EncodeOutputStream __ENCODED_OUT_BUFFER__ = null;
	protected BASE64DecodeOutputStream __DECODED_OUT_BUFFER__ = null;
	
	/** Creates new InfoComunicator */
	public InfoComunicator() {
		super( false );
		setName( "InfoComunicator" );
		__OUT_BUFFER__ = new ByteArrayOutputStream( 1024 );
		__ENCODED_OUT_BUFFER__ = new BASE64EncodeOutputStream( __OUT_BUFFER__ , 1024 );
		__DECODED_OUT_BUFFER__ = new BASE64DecodeOutputStream( __OUT_BUFFER__ , 1024 );
	}
	
	public void setLimitTime( int time ){
		CONNECTION_DELAY = time;
	}
	
	public void setInfoBeans( InfoBeans arg ) {
		this.beans = arg;
	}
	
	public InfoBeans execute() throws Exception {
		if( this.beans == null ) throw new RuntimeException("InfoBean is not set!");
		
		String body = null;
		
		__ENCODED_OUT_BUFFER__.flush();
		__OUT_BUFFER__.reset();
		
		for( Enumeration eNum = this.beans.propertyNames() ; eNum.hasMoreElements() ; ){
			String key = ( String )eNum.nextElement();
			
			__OUT_BUFFER__.write( KEY_HEADER );
			__OUT_BUFFER__.write( key.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET) );
			__OUT_BUFFER__.write( KEY_NEWLINE );
			
			__ENCODED_OUT_BUFFER__.write( this.beans.getProperty( key ).getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET) );
			__ENCODED_OUT_BUFFER__.flush();
			
			__OUT_BUFFER__.write( KEY_NEWLINE );
			__OUT_BUFFER__.write( KEY_NEWLINE );
			__OUT_BUFFER__.flush();
		}
		
		__OUT_BUFFER__.write( KEY_NEWLINE );
		__OUT_BUFFER__.write( KEY_ENDING_POINT );
		__OUT_BUFFER__.flush();
		
		body = __OUT_BUFFER__.toString();
		if (log.isDebugEnabled()) {
			log.debug(body);
		}
		
		try {
			connect( this.beans.getServerIP() , this.beans.getServerPORT() );
			setConnectionTimeout( CONNECTION_DELAY );
			// 초기 OK SIGN 받기
			
			String message = receive();
			
			if( message == null ) throw new RuntimeException( "WELCOME MESSAGE IS NULL");
			
			if( !message.equalsIgnoreCase("OK") ) throw new RuntimeException( "SERVER RETURN INVALID MESSAGE[" + message + "]");
			
			super.send( "actor" );
			
			/** 빈즈를 스트링으로 변환한 것을 전송한다.
			 */
			//log.debug( body );
			super.send( body );
			
			/**결과로 넘어오는 빈즈를 받는다.
			 */
			while( true ) {
				message = super.receive();
				
				if( message == null || message.equals( "." ) ) break;
				
				if( message.length() < 1 ){
					continue;
				}
				
				/**프로퍼티 키가 나온다면.
				 */
				if( message.startsWith( KEY_HEADER_STRING ) ){
					String key = message.substring( KEY_HEADER_STRING.length() );
					__DECODED_OUT_BUFFER__.flush();
					__OUT_BUFFER__.reset();
					while( true ){
						message = super.receive();
						
						if( message == null || message.length() < 1 ) {
							break;
						}
						__DECODED_OUT_BUFFER__.write( message.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET) );
					}
					__DECODED_OUT_BUFFER__.flush();
					__OUT_BUFFER__.flush();
					
					this.beans.setProperty( key , __OUT_BUFFER__.toString( eMsLocale.CHAR_SET ) );
					
				}
			}
			
			return this.beans;
		}
		catch( Exception e) {
			throw e;
		}
		finally {
			try{ super.close(); }catch( Exception e ){}
			try{ super.unregist(); }catch( Exception e ){}
		}
	}
	
	public static void main( String[] arg ) throws Exception{
		InfoBeans scontent = new InfoBeans();
		
		Properties prop = new Properties();
		
		/*
		 * 다음 정보를 세팅하기 위해서는 WORKDAY, SEQNO, MEMBER_ID, MEMBER_ID_SEQ 값으로 AUTO120을
		 * SELECT해서 MAPPING, MEMBER_NAME을 세팅해야 한다.
		 * server ip는 발송서버의 IP(내부면 내부IP)
		 * port는 jupiter_auto_send_conf.xml에 listener.port의 값을 세팅
		 * 위의 IP와 Port는 웹에서 호출시에는 환경변수로 빼는 것이 좋다.
		 */
		
		prop.setProperty( "WORKDAY" , "20061115");
		prop.setProperty( "SEQNO" , "1");
		prop.setProperty( "MEMBER_ID" , "amail4");
		prop.setProperty( "MEMBER_ID_SEQ" , "30890184");
		prop.setProperty( "POST_ID" , "20061115_1");
		prop.setProperty( "MAPPING" , "amail4|에이메일4|aiwhite75@yahoo.co.kr|매핑4-1|매핑4-2|1000000[{리스트4-1-1|리스트4-1-2}{리스트4-2-1|리스트4-2-2}]");
		
		prop.setProperty( "MEMBER_NAME" , "에이메일4");
		
		

		scontent.setArgs( prop );
		scontent.setHandler( "jupiter.auto.actor.ContentsPreviewInfoActor" );
		scontent.setServerIP("218.55.16.42");
		scontent.setServerPORT(Integer.parseInt("9998"));
	
		InfoComunicator tester = new InfoComunicator();
	
		tester.setInfoBeans(scontent);
	
		scontent = tester.execute();
	
		String member_content = scontent.getProperty( "CONTENTS" );
		
		if (log.isDebugEnabled()) {
			log.debug(member_content);
		}
		
		System.exit( 0 );
	}	
}
