/*
 * InfoBeans.java
 *
 * Created on 2003년 4월 17일 목, 오후 4:33
 */

package pluto.net.communicator;

import java.util.Properties;
/**
 *
 * @author  Administrator
 * @version
 */
public class InfoBeans extends Properties {
	public static final String KEY_SERVER_IP = "#KEY_SERVER_IP";
	public static final String KEY_SERVER_PORT = "#KEY_SERVER_PORT";
	public static final String KEY_SERVER_HANDLER = "#KEY_SERVER_HANDLER";

	/** Getter for property serverIP.
	 * @return Value of property serverIP.
	 */
	public String getServerIP() {
		return super.getProperty( KEY_SERVER_IP );
	}
	
	
	/** Setter for property serverIP.
	 * @param serverIP New value of property serverIP.
	 */
	public void setServerIP(String serverIP) {
		super.setProperty( KEY_SERVER_IP , serverIP );
	}
	
	
	/** Getter for property serverPORT.
	 * @return Value of property serverPORT.
	 */
	public int getServerPORT() {
		return Integer.parseInt( super.getProperty( KEY_SERVER_PORT ) );
	}
	
	/** Setter for property serverPORT.
	 * @param serverPORT New value of property serverPORT.
	 */
	public void setServerPORT(int serverPORT) {
		super.setProperty( KEY_SERVER_PORT , String.valueOf( serverPORT ) );
	}
	
	/** Getter for property handler.
	 * @return Value of property handler.
	 */
	public String getHandler() {
		return super.getProperty( KEY_SERVER_HANDLER );
	}
	
	/** Setter for property handler.
	 * @param handler New value of property handler.
	 */
	public void setHandler(String handler) {
		super.setProperty( KEY_SERVER_HANDLER , handler );
	}
	
	/** Getter for property args.
	 * @return Value of property args.
	 */
	public Properties getArgs() {
		return this;
	}
	
	/** Setter for property args.
	 * @param args New value of property args.
	 */
	public void setArgs(Properties args) {
		this.putAll( args );
	}
}

