package pluto.net.communicator;

import java.util.Properties;

import pluto.lang.Name;
import lombok.extern.slf4j.Slf4j;
import pluto.panopticon.monitor.MailSendDomainFilter;
import pluto.util.Cal;

@Slf4j
public class DomainFilterActor extends Name implements InfoActor{
	
	
	
	
	public DomainFilterActor(){
		this.setName( "DomainFilterActor" + Cal.getSerialDate() );
	}
	
	
	public void execute(InfoBeans arg) throws Exception {
		if (log.isDebugEnabled()) {
			log.debug("[execute]...[start]" );
		}
		
		Properties prop = arg.getArgs();
		
		String actFlag = prop.getProperty("ACTFLAG");
		
		String act_time = prop.getProperty("ACTTIME");
		String domain = prop.getProperty("DOMAIN");
		
		if(log.isDebugEnabled()){
			log.debug("[ACTFLAG] :"+actFlag );
			log.debug("[ACTTIME]:"+act_time );
			log.debug("[DOMAIN]  :"+domain );
		}
		
		//code : ADD, DEL, USE
		if(actFlag.equals("ADD")){
			if (log.isDebugEnabled()) {
				log.debug("[ADD]");
			}
			addList(act_time,domain);
		}else if(actFlag.equals("DEL")){
			if (log.isDebugEnabled()) {
				log.debug("[DELETE]");
			}
			delList(domain);
		}else if(actFlag.equals("USE")){
			if (log.isDebugEnabled()) {
				log.debug("[USE DOMAIN FILTER]");
			}
			useList();
		}else if(actFlag.equals("NOUSE")){
			if (log.isDebugEnabled()) {
				log.debug("[NO USE DOMAIN FILTER]");
			}
			noUseList();
		}
		
		
		
		
		
		prop.setProperty("RESULT", "act_end");
		
		if (log.isDebugEnabled()) {
			log.debug("[execute]...[end]" );
		}
	}
	
	
	
	/**
	 * 리스트에 등록
	 * @return
	 */
	public void addList(String act_time, String domain){
		MailSendDomainFilter.registeFilteringDomain(act_time, domain);
		String list_String = MailSendDomainFilter.getInfo();
		if (log.isDebugEnabled()) {
			log.debug("[FILTER_DOMAIN_LIST]...\n"+list_String );
			log.debug(MailSendDomainFilter.isFilterPresent()?"[INIT_FLAG]:true":"[INIT_FLAG]:false");
		}
	}
	
	
	/**
	 * 리스트에서 삭제
	 * @return
	 */
	public void delList(String domain){
		//리스트에서 삭제
		MailSendDomainFilter.deRegisterFilteringDomain( domain );		
		String list_String = MailSendDomainFilter.getInfo();
		if (log.isDebugEnabled()) {
			log.debug("[FILTER_DOMAIN_LIST]...\n"+list_String );
			log.debug(MailSendDomainFilter.isFilterPresent()?"[INIT_FLAG]:true":"[INIT_FLAG]:false");
		}
	}
	
	/**
	 * 도메인 필터를 사용함으로 설정
	 */
	public void useList(){
		MailSendDomainFilter.setINIT_FLAG(true);
		String list_String = MailSendDomainFilter.getInfo();
		if (log.isDebugEnabled()) {
			log.debug("[FILTER_DOMAIN_LIST]...\n"+list_String );
			log.debug(MailSendDomainFilter.isFilterPresent()?"[INIT_FLAG]:true":"[INIT_FLAG]:false");
		}
	}
	
	/**
	 * 도메인 필터를 사용안함으로 설정
	 */
	public void noUseList(){
		MailSendDomainFilter.setINIT_FLAG(false);
		String list_String = MailSendDomainFilter.getInfo();
		if (log.isDebugEnabled()) {
			log.debug("[FILTER_DOMAIN_LIST]...\n"+list_String );
			log.debug(MailSendDomainFilter.isFilterPresent()?"[INIT_FLAG]:true":"[INIT_FLAG]:false");
		}
	}
	
}




