/*
 * CommunicationWorker.java
 *
 * Created on 2003년 4월 17일 목, 오후 8:22
 */

package pluto.net.communicator;

import java.io.ByteArrayOutputStream;
import java.net.Socket;
import java.util.Enumeration;

import pluto.io.BASE64DecodeOutputStream;
import pluto.io.BASE64EncodeOutputStream;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.net.SocketReaderAgent;
/** 수신서버측에서 동작하는 공용Worker
 * @author Administrator
 * @version 1.0
 */
@Slf4j
public class CommunicationWorker extends SocketReaderAgent implements Runnable{
	
	
    private static final int __CONNECTION_DELAY__ = 360*1000;
    
    private static byte[] KEY_HEADER = null;
    private static String KEY_HEADER_STRING = null;
    private static byte[] KEY_ENDING_POINT = null;
    private static byte[] KEY_NEWLINE = null;
    
    protected static Object __LOCK_OF_BUFFER__ = new Object();
    
    static{
        KEY_HEADER_STRING = "##";
        KEY_HEADER = KEY_HEADER_STRING.getBytes();
        KEY_NEWLINE = "\r\n".getBytes();
        KEY_ENDING_POINT = ".".getBytes();
    }
        /*
         *넘겨줄 빈즈를 바이트로 바꿔서 다시 인코딩을 한다.
         */
    protected ByteArrayOutputStream __OUT_BUFFER__ = null;
    protected BASE64EncodeOutputStream __ENCODED_OUT_BUFFER__ = null;
    protected BASE64DecodeOutputStream __DECODED_OUT_BUFFER__ = null;
    
    ThreadGroup __REGIST_THREAD_GROUP__ = null;
    Socket __SOURCE_SOCKET__ = null;
    
    /** Creates new CommunicationWorker
     * @param group 내부로 동작할 쓰레드가 속할 ThreadGroup
     * @param name 내부동작 Thread의 이름
     * @param mySocket Client에서 접속된 Socket연결
     */
    public CommunicationWorker( ThreadGroup group , String name , Socket mySocket ) {
        super( true );
        setName( name );
        this.__REGIST_THREAD_GROUP__ = group;
        this.__SOURCE_SOCKET__ = mySocket;
        
        __OUT_BUFFER__ = new ByteArrayOutputStream( 1024 );
        __ENCODED_OUT_BUFFER__ = new BASE64EncodeOutputStream( __OUT_BUFFER__ , 1024 );
        __DECODED_OUT_BUFFER__ = new BASE64DecodeOutputStream( __OUT_BUFFER__ , 1024 );
        if(log.isDebugEnabled()){
        	// foo
        }
    }
    
    /** 실제적으로 Worker를 구동한다.
     * @throws Exception 내부 Thread를 생성하는 곳까지 throw 되는 Exception
     */
    public void start() throws Exception {
        connect( this.__SOURCE_SOCKET__ );
        setConnectionTimeout( __CONNECTION_DELAY__ );
        
        Thread inner_thread = new Thread( this.__REGIST_THREAD_GROUP__ , this , getName() );
        inner_thread.start();
    }
    
    /** 최초 접속이 잘 되었음을 알려주는 메세지
     */
    public static final String MESSAGE_OK = "OK";
    
    /** 전체 작업을 감싸는 method
     */
    public void run() {
        try {
            work();
        }
        catch( Exception e ) {
            log.error( "CommunicationError" , e );
        }
        finally {
            try{ this.close(); }catch( Exception e ){}
            try{ super.unregist(); }catch( Exception e ){}
        }
    }
    
    /** 세부 작업을 정의
     * @throws Exception 주로 네트웍오류나 작업시 발생하는 Exception
     */
    public void work() throws Exception {
        log.debug("Connection in...");
        // 초기 OK SIGN 받기
        
        super.send( MESSAGE_OK );
        String message = null;
        
        /**최초 한줄을 받는다.
         */
        message = super.receive();
        log.debug("receive=>".concat( message ) );
        if( message.startsWith( "exec " ) ){
            log.info("COMMAND TYPE" );
            exec_external( message.substring( 5 ) );
            return;
        }
        
        log.debug("INFO TYPE" );
        
        InfoBeans target = new InfoBeans();
        
        while( true ){
            message = super.receive();
            
            if( message == null ){
                log.debug("receive null break...." );
                break;
            }
            
            if( message.length() < 1 ) continue;
            
            if( message.equals( "." ) ) break;
            
            /**
             * 프로퍼티 키가 나온다면. 
             */ 
            if( message.startsWith( KEY_HEADER_STRING ) ){
                String key = message.substring( KEY_HEADER_STRING.length() );
                __DECODED_OUT_BUFFER__.flush();
                __OUT_BUFFER__.reset();
                while( true ){
                    message = super.receive();
                    
                    if( message == null || message.length() < 1 ) break;
                    __DECODED_OUT_BUFFER__.write( message.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET) );
                }
                __DECODED_OUT_BUFFER__.flush();
                __OUT_BUFFER__.flush();
                
                target.setProperty( key , __OUT_BUFFER__.toString( eMsLocale.CHAR_SET ) );
                
            }
        }
        
        if( target.getHandler() == null ){
            log.error( "INPUT HANDLER IS NULL");
            target.setProperty( "ERROR" , "INPUT HANDLER IS NULL" );
        }
        else{
            log.debug("create Actor Instance => ".concat( target.getHandler() ));
            
            InfoActor actor = null;
            try{
                actor = ( InfoActor )( Class.forName( target.getHandler() ).newInstance() );
                log.debug("execute Actor's execute method" );
                
                
                
                
                if(target.getHandler().equals("pluto.net.communicator.SendLogFindActor")){
                	SendLogFindActor logGreper = (SendLogFindActor)actor;
                	logGreper.setThreadName(this.getName());
                	
                	super.send("@@"+this.getName());
                	
                	SendLogFindActor.NOW_ACT_CNT++;
                	logGreper.execute( target, this.SMTP_BINARY_OUTSTREAM );
                	SendLogFindActor.NOW_ACT_CNT--;
                	
                }else{
                	actor.execute( target );
                }
                
                log.debug("execute Actor's execute method end..." );
            }
            catch( ClassNotFoundException e ){
                log.error( "UNKNOWN HANDLER " ,	target.getHandler() );
                target.setProperty( "ERROR" , "UNKNOWN HANDLER=>" +  target.getHandler() );
            }
        }
        String body = null;
        
        
        __ENCODED_OUT_BUFFER__.flush();
        __OUT_BUFFER__.reset();
        
        for( Enumeration eNum = target.propertyNames() ; eNum.hasMoreElements() ; ){
            String key = ( String )eNum.nextElement();
            
            __OUT_BUFFER__.write( KEY_HEADER );
            __OUT_BUFFER__.write( key.getBytes( eMsLocale.FILE_SYSTEM_IN_CHAR_SET) );
            __OUT_BUFFER__.write( KEY_NEWLINE );
            
            __ENCODED_OUT_BUFFER__.write( target.getProperty( key ).getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET) );
            __ENCODED_OUT_BUFFER__.flush();
            
            __OUT_BUFFER__.write( KEY_NEWLINE );
            __OUT_BUFFER__.write( KEY_NEWLINE );
            __OUT_BUFFER__.flush();
        }
        
        __OUT_BUFFER__.write( KEY_NEWLINE );
        __OUT_BUFFER__.write( KEY_ENDING_POINT );
        __OUT_BUFFER__.flush();
        
        body = __OUT_BUFFER__.toString();
        
        
        super.send( body );
    }
    
    protected void exec_external( String classname ) throws Exception{
        CommandActor actor = ( CommandActor )( Class.forName( classname ).newInstance() );
        String message = actor.exec();
        super.send( message );
        super.send( "." );
        return;
    }
    
}
