/*
 * CommunicationServerActivator.java
 *
 * Created on 2003년 4월 17일 목, 오후 4:55
 */

package pluto.net.communicator;

import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.UniqueKey;
/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public class CommunicationServerActivator extends Thread {
	protected static int _LISTENER_PORT_ =0;
	protected static int _QUE_SIZE_ = 0;
	
	public static void init( Object tmp ) throws Exception {
		Properties prop = ( Properties )tmp;
		
		_LISTENER_PORT_ = Integer.parseInt( prop.getProperty("listener.port") );
		_QUE_SIZE_ =  Integer.parseInt( prop.getProperty("listener.quesize"));
	}
	
	/** Creates new CommunicationServerActivator */
	public CommunicationServerActivator() throws Exception{
		s_socket = new ServerSocket( _LISTENER_PORT_ , _QUE_SIZE_ );
	}
	
	private ServerSocket s_socket = null;
	
	public void run() {
		log.debug("TCP SERVER START");
		while( true ) {
			try {
				Socket ReceiveSocket = s_socket.accept();
				CommunicationWorker myWorker = new CommunicationWorker( pluto.lang.eMsLocale.EMS_ROOT_THREAD_GROUP , "Actor@".concat( ReceiveSocket.getInetAddress().getHostAddress() ).concat("@").concat( UniqueKey.get() ) , ReceiveSocket );
				myWorker.start();
			}
			catch( Exception e ) {
				log.error(e.getMessage());
				if(e instanceof BindException){
					System.exit(-1);
				}
				try{ Thread.currentThread().sleep( 10000 ); }catch( Exception ex ){}
			}
		}
	}
}
