/*
 * CommunicationServerActivator.java
 *
 * Created on 2003년 4월 17일 목, 오후 4:55
 */

package pluto.net.communicator;

import java.net.ServerSocket;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public class ActiveMQServerActivator extends Thread {
	
	protected static boolean 		DEBUG_FLAG 		= true;
	
	protected static String 		BROKER_URL 		= "";
	protected static String 		BROKER_ID 		= "";
	protected static String 		BROKER_PASSWD 	= "";
	
	protected static String 		RESPONSE_MQ_NAME 		= "";
	
	protected static int 			CONSUMER_SIZE 	= 0;

	protected static Properties		PROP			= null;
	
	protected static String			ENG_TYPE			= "";
	
	public static void init( Object tmp ) throws Exception {
		
		Properties prop = ( Properties )tmp;
		
		BROKER_URL  =  prop.getProperty("activemq.broker.url");
		
		RESPONSE_MQ_NAME	=  prop.getProperty("response.activemq.que.name");
		
		CONSUMER_SIZE =  Integer.parseInt( prop.getProperty("consumer.size","5"));
		
		
		//-------- 설정정보 로깅 시작 ----------//
				infoReport(prop);
		//-------- 설정정보 로깅 종료 ----------//
		
	}
	
	/** Creates new ActiveMQServerActivator */
	public ActiveMQServerActivator() throws Exception{
		
	}
	
	public void run() {
		int consumerCnt = 0;
		
		log.debug("========= MQ start() START =========");
		for(int k=0;k<CONSUMER_SIZE;k++){
			consumerCnt ++;
			Properties prp =  new Properties();
			prp.setProperty("BROKER_URL", BROKER_URL);
			
			prp.setProperty("RESPONSE_MQ_NAME", RESPONSE_MQ_NAME);
			
			MQConsumer	CONSUMER  = new MQConsumer(prp);
		
			try {
				CONSUMER.start();
				
				Thread.currentThread().sleep(200);
			}
			catch( Exception e ) {
				//e.printStackTrace();
				log.error("Error MqConsumer  Start :{} ", e);
				CONSUMER.release();
				try{ Thread.currentThread().sleep( 10000 ); }catch( Exception ex ){}
			}
		}
		log.debug("========= MQ start() END =========");
		
		log.debug("MQ CONSUMER SIZE...."+consumerCnt);
	}
	
	public static void infoReport(Properties prop){

		log.debug("activemq.broker.url : {}", prop.getProperty("activemq.broker.url"));
		log.debug("response.activemq.name : {}", prop.getProperty("response.activemq.name"));
		log.debug("consumer.size: {}", prop.getProperty("consumer.size","5"));
		
	}
}


