/*
 * SocketReaderAgent.java
 *
 * Created on 2003년 9월 13일 (토), 오후 4:43
 */

package pluto.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import lombok.extern.slf4j.Slf4j;
import pluto.io.TelnetOutputStream;
import pluto.ioutil.FileUtil;

/**
 * 
 * @author Administrator
 */
@Slf4j
public class SocketReaderAgent extends SocketAgent {

	protected BufferedReader		SMTP_STRING_READER		= null;

	protected TelnetOutputStream	SMTP_BINARY_OUTSTREAM	= null;

	/** Creates a new instance of SocketReaderAgent */
	public SocketReaderAgent() {
		super(false);
	}

	public SocketReaderAgent(boolean regist) {
		super(regist);
	}

	protected void openConnection() throws IOException {
		this.SMTP_STRING_READER = new BufferedReader(new InputStreamReader(this.CONNECTED_SOCKET.getInputStream()));
		this.SMTP_BINARY_OUTSTREAM = new TelnetOutputStream(this.CONNECTED_SOCKET.getOutputStream());
	}

	public void killSession() {
		FileUtil.close(this.SMTP_STRING_READER);
		FileUtil.close(this.SMTP_BINARY_OUTSTREAM);

		super.killSession();
	}
	/**
	 * 메세지를 전송한다.
	 * 
	 * @param source
	 *            전송할 메세지
	 * @throws IOException
	 *             전송중 에러
	 */
	protected void send(String source) throws IOException {
		if( source == null )
			return;

		if( source.length() == 0 ) {
			this.SMTP_BINARY_OUTSTREAM.writeln();
		}
		else {
			if (log.isDebugEnabled()) 
				log.debug(source);
			this.SMTP_BINARY_OUTSTREAM.write(source);
			this.SMTP_BINARY_OUTSTREAM.writeln();
		}
	}

	/**
	 * byte 배열의 메세지를 전송한다.
	 * 
	 * @param source
	 *            전송할 byte 배열
	 * @throws IOException
	 *             전송중 에러
	 */
	protected void send(byte[] source) throws IOException {
		if( source == null )
			return;

		if( source.length == 0 ) {
			this.SMTP_BINARY_OUTSTREAM.writeln();
		}
		else {
			if (log.isDebugEnabled()) 
				log.debug(new String(source));
			this.SMTP_BINARY_OUTSTREAM.write(source);
			this.SMTP_BINARY_OUTSTREAM.writeln();
		}
	}

	/**
	 * 메일 서버로 부터 메세지를 받는다.
	 * 
	 * @throws IOException
	 *             전송중 에러
	 * @return 전송된 메세지
	 */
	protected String receive() throws IOException {
		String readLIne = this.SMTP_STRING_READER.readLine();
		if (log.isDebugEnabled()) 
			log.debug(readLIne);
		return readLIne;
	}
}
