/*
 * SocketInputStreamAgent.java
 *
 * Created on 2003년 9월 13일 (토), 오후 4:51
 */

package pluto.net;

import java.io.BufferedInputStream;
import java.io.IOException;

import lombok.extern.slf4j.Slf4j;
import pluto.io.TelnetOutputStream;
import pluto.ioutil.FileUtil;

/**
 * 
 * @author Administrator
 */
@Slf4j
public class SocketInputStreamAgent extends SocketReaderAgent {

	protected BufferedInputStream	SMTP_BINARY_INSTREAM	= null;

	/** Creates a new instance of SocketInputStreamAgent */
	public SocketInputStreamAgent() {
		super();
	}

	public SocketInputStreamAgent(boolean regist) {
		super(regist);
	}

	protected void openConnection() throws IOException {
		this.SMTP_BINARY_INSTREAM = new BufferedInputStream(this.CONNECTED_SOCKET.getInputStream());
		this.SMTP_BINARY_OUTSTREAM = new TelnetOutputStream(this.CONNECTED_SOCKET.getOutputStream());
	}

	public void killSession() {
		FileUtil.close(this.SMTP_BINARY_INSTREAM);
		FileUtil.close(this.SMTP_BINARY_OUTSTREAM);

		super.killSession();
	}

	/**
	 * 메세지를 전송한다.
	 * 
	 * @param source
	 *            전송할 메세지
	 * @throws IOException
	 *             전송중 에러
	 */
	protected void send(String source) throws IOException {
		if( source == null )
			return;

		if( source.length() > 0 ) {
			if (log.isDebugEnabled()) 
				log.debug("===> " + source);
			this.SMTP_BINARY_OUTSTREAM.write(source);
			this.SMTP_BINARY_OUTSTREAM.flush();
		}
	}

	/**
	 * byte 배열의 메세지를 전송한다.
	 * 
	 * @param source
	 *            전송할 byte 배열
	 * @throws IOException
	 *             전송중 에러
	 */
	protected void send(byte[] source) throws IOException {
		if( source == null )
			return;

		if( source.length > 0 ) {
			if (log.isDebugEnabled()) 
				log.debug("===> " + new String(source));
			this.SMTP_BINARY_OUTSTREAM.write(source);
			this.SMTP_BINARY_OUTSTREAM.flush();
		}
	}

	protected int receive(byte[] buffer) throws IOException {
		return this.SMTP_BINARY_INSTREAM.read(buffer);
	}
}
