/*
 * SocketAgentMonitor.java
 *
 * Created on 2003년 3월 5일 수, 오후 10:32
 */

package pluto.net;

import java.util.LinkedList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.schedule.ScheduledMonitor;

/**
 * 등록된 SocketAgent의 통신상태를 점검하여 기준시간 이상 반응이 없는 Agent의 Connection을 정리한다.
 * 
 * @author 이상근
 * @version 3.0
 */
@Slf4j
public class SocketAgentMonitor extends ScheduledMonitor {

	private static Object				lock			= new Object();

	/**
	 * 쓰레드 체크를 위한 리스트
	 */
	private static List					ContainThreads	= new LinkedList();

	private static SocketAgentMonitor	innerManager	= null;

	private static Object[]				TMP_AGENT_ARRAY	= null;

	/**
	 * Creates new SocketAgentMonitor
	 * 
	 * @param a
	 *        모니터링 주기
	 */
	private SocketAgentMonitor(long a) {
		super(a, "SocketAgentMonitor");
	}

	/**
	 * 외부에서 실제적으로 SocketAgent를 등록
	 * 
	 * @param target
	 *        관리할 SocketAgent
	 * @return 성공여부
	 */
	public static boolean registSocketAgent(NetworkMonitorable target) {
		/**
		 * 내부 인스턴스를 초기화 한다.
		 */
		if( innerManager == null ) {
			innerManager = new SocketAgentMonitor(eMsLocale.SMTP_AGENT_IDLE_CHECK_INTERVAL);
			innerManager.start();
		}

		synchronized (lock) {
			if( ContainThreads.contains(target) ) {
				return false;
			}

			return ContainThreads.add(target);
		}
	}

	public static boolean removeSocketAgent(SocketAgent target) {
		synchronized (lock) {
			return ContainThreads.remove(target);
		}
	}

	/**
	 * 모니터링을 종료한다.
	 */
	public static void destroy() {
		if( innerManager != null ) {
			innerManager.close();
		}
	}

	/**
	 * 실질적인 검사를 한다.
	 */
	protected void check() {
		if (log.isDebugEnabled()) 
			log.debug("Check IDLE Agent..");
		// 일하고 있는 녀석들의 시간을 체크하여
		// 삐꾸는 바로 죽인다.
		synchronized (lock) {
			if( TMP_AGENT_ARRAY == null ) {
				TMP_AGENT_ARRAY = ContainThreads.toArray();
			}
			else {
				TMP_AGENT_ARRAY = ContainThreads.toArray(TMP_AGENT_ARRAY);
			}
		}

		int size = ContainThreads.size();

		for (int i = 0; i < size; i++) {
			NetworkMonitorable target = (NetworkMonitorable) TMP_AGENT_ARRAY[i];
			if( target.isIdle() ) {
				log.info("IDLE AGENT FOUND", target.getConnectHost());
				target.killSession();
				log.info("IDLE AGENT KILL SESSION", target.getName());
			}
		}
		if (log.isDebugEnabled()) 
			log.debug("Check IDLE Agent..[END]");
	}
}
