/*
 * Created on 2005. 3. 2.
 *
 */
package pluto.net;

import java.net.InetAddress;
import java.net.UnknownHostException;

import lombok.extern.slf4j.Slf4j;

/**
 * IP base 호스트 이름을 처리하는 기타 등등의 일을 하는 static method를 모아 놓
 * 
 * @author EMS
 */
@Slf4j
public class NetAddress {
	/**
	 * IP base String 을 InetAddress로 전환한다.
	 * 
	 * @param addr
	 *            IP base Host Name
	 * @return java.net.InetAddress
	 * @throws UnknownHostException
	 *             엉뚱한 도메인을 넣거나 Domain Name base String을 잘 못 넣으면 발
	 */
	public static final InetAddress getInetAddress(String addr) throws UnknownHostException {
		byte[] returnValue = getByteArray(addr);
		return returnValue == null ? null : InetAddress.getByAddress(returnValue);
	}

	/**
	 * IP base Address를 InetAddress로 전환 가능한 byte array로 전환한다.
	 * 
	 * @param addr
	 *            IP base address
	 * @return byte array
	 */
	public static final byte[] getByteArray(String addr) {
		byte[] returnValue = new byte[4];

		int idx1 = addr.indexOf('.');

		if( idx1 < 0 ) {
			log.info("getRawAddr() FIND FIRST INDEX FAIL", addr);
			return null;
		}

		// 첫번째 숫자를 더하고...
		returnValue[0] = (byte) (Integer.parseInt(addr.substring(0, idx1)) & 0xFF);

		idx1++;

		int idx2 = addr.indexOf('.', idx1);

		if( idx2 < 0 ) {
			log.error("getRawAddr() FIND SECOND INDEX FAIL", addr);
			return null;
		}

		// 두번째 숫자를 더하고
		returnValue[1] = (byte) (Integer.parseInt(addr.substring(idx1, idx2)) & 0xFF);

		idx1 = idx2 + 1;

		idx2 = addr.indexOf('.', idx1);

		if( idx2 < 0 ) {
			log.error("getRawAddr() FIND THIRD INDEX FAIL", addr);
			return null;
		}

		// 세번째 숫자를 더하
		returnValue[2] = (byte) (Integer.parseInt(addr.substring(idx1, idx2)) & 0xFF);

		// 네번째 숫자를 더하
		returnValue[3] = (byte) (Integer.parseInt(addr.substring(idx2 + 1)) & 0xFF);

		return returnValue;
	}

	/**
	 * IP base Address를 InetAddress로 전환 가능한 int array로 전환한다.
	 * 
	 * @param addr
	 *            IP base address
	 * @return int array
	 */
	public static final int[] getIntArray(String addr) {
		int[] returnValue = new int[4];

		int idx1 = addr.indexOf('.');

		if( idx1 < 0 ) {
			log.info("getRawAddr() FIND FIRST INDEX FAIL", addr);
			return null;
		}

		// 첫번째 숫자를 더하고...
		returnValue[0] = Integer.parseInt(addr.substring(0, idx1));

		idx1++;

		int idx2 = addr.indexOf('.', idx1);

		if( idx2 < 0 ) {
			log.info("getRawAddr() FIND SECOND INDEX FAIL", addr);
			return null;
		}

		// 두번째 숫자를 더하고
		returnValue[1] = Integer.parseInt(addr.substring(idx1, idx2));

		idx1 = idx2 + 1;

		idx2 = addr.indexOf('.', idx1);

		if( idx2 < 0 ) {
			log.info("getRawAddr() FIND THIRD INDEX FAIL", addr);
			return null;
		}

		// 세번째 숫자를 더하
		returnValue[2] = Integer.parseInt(addr.substring(idx1, idx2));

		// 네번째 숫자를 더하
		returnValue[3] = Integer.parseInt(addr.substring(idx2 + 1));

		return returnValue;
	}

	/**
	 * IP address를 나타내는 byte array를 IP base String으로 전환한다.
	 * 
	 * @param addr
	 *            byte array
	 * @return IP base String
	 */
	public static String toDottedQuad(byte[] addr) {
		return ((addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[3] & 0xFF));
	}
}
