/*
 * Created on 2005. 10. 21.
 */
package pluto.net;

import java.util.Hashtable;

import pluto.lang.eMsLocale;

/**
 * @author 이상근
 */
public class BlackListContainer {
	private static Hashtable	BLACK_LIST					= null;

	private static int			MAX_REJECT_COUNT			= 100;

	private static long			BLACK_LIST_REJECT_INTERVAL	= eMsLocale.BLACK_LIST_REJECT_INTERVAL;

	static {
		BLACK_LIST = new Hashtable();
	}

	public synchronized static void registBlackListDomain(String domain) {
		BlackListInfo info = (BlackListInfo) BLACK_LIST.get(domain);

		if( info == null ) {
			info = new BlackListInfo(domain);
			BLACK_LIST.put(domain, info);
			return;
		}

		info.refresh();
	}

	public synchronized static boolean isBlackListDomain(String domain) {
		if( domain == null ) {
			return false;
		}
		BlackListInfo info = (BlackListInfo) BLACK_LIST.get(domain);

		if( info != null ) {
			return info.isRejectTime();
		}

		return false;
	}

	static class BlackListInfo {
		long	currentTime		= -1;

		int		iRejectCount	= 0;

		String	id				= null;

		BlackListInfo(String domain) {
			id = domain;
			refresh();
		}

		String getID() {
			return id;
		}

		void refresh() {
			currentTime = System.currentTimeMillis() + BLACK_LIST_REJECT_INTERVAL;
			iRejectCount = 0;
		}

		/**
		 * 마지막 발생한 시간으로부터 지정시간이 지났는지 여부를 반환한다.
		 * 
		 * @return
		 */
		boolean isRejectTime() {
			if( currentTime > System.currentTimeMillis() ) {
				iRejectCount++;
				if( MAX_REJECT_COUNT < iRejectCount ) {
					iRejectCount = 0;
					currentTime = System.currentTimeMillis() - 1;
				}
			}
			return (currentTime > System.currentTimeMillis());
		}
	}
}
