package pluto.mgs.util;

import java.util.concurrent.atomic.AtomicInteger;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SequenceIncreaseIdFactory extends SequenceIdFactory implements Runnable{
	
	private AtomicInteger id = new AtomicInteger(10000000);
	
	public void run(){
		super.run();
		while(true){
			try {
				Thread.sleep(1000*60*60*24L);
				if(id.decrementAndGet() > Integer.MAX_VALUE-100000000){
					id.set(10000000);
				}
			} catch (Exception e) {
				// TODO: handle exception
				log.error("Exception",e);
			}
		}
	}

	@Override
	public String createSequence() {
			return ""+id.getAndIncrement();
	}
}
