/*
 * Created on 2005. 12. 6
 */
package pluto.mail.mx;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsByteArrayOutputStream;

/**
 * @author 이상근
 */
@Slf4j
public class UDPMXLookup extends MXLookup {

	protected DatagramSocket		CONNECTED_SOCKET	= null;

	protected UDPMXLookup() {
		super();
	}

	protected int getDNSResult(InetAddress address, byte[] query, eMsByteArrayOutputStream buffer) throws Throwable {
		int responseLength = -1;

		// 512정도는 되어야 한다.
		buffer.ensureSize(512);

		byte[] rawBuffer = buffer.getRawByteArray();
		for (int i = 0; i < 3; i++) {

			try {
				// TODO 이 연결에 대해서 모니터링 할 수 있도록 멤버변수로 전환하고
				// 연결을 재활용 가능한지 여부에 대한 ... 고찰..
				this.CONNECTED_SOCKET = new DatagramSocket();

				DatagramPacket packet = new DatagramPacket(query, query.length, address, 53);

				setConnectionTimeout(2000);

				this.CONNECTED_SOCKET.send(packet);

				DatagramPacket packet2 = new DatagramPacket(rawBuffer, rawBuffer.length);
				this.CONNECTED_SOCKET.receive(packet2);

				responseLength = packet2.getLength();

				break;
			}
			catch(IOException thw) {
				log("IOException occur During DNS Query to:" + address.getHostAddress());
			}
			finally {
				close();
			}
		}
		return responseLength;
	}

	public void close() {
		this.CONNECT_HOST = null;

		this.IN_COMM = false;
		this.COMM_START_TIME = -1;

		killSession();

		this.CONNECTED_SOCKET = null;
	}

	public void killSession() {
		if( this.CONNECTED_SOCKET != null ) {
			try {
				this.CONNECTED_SOCKET.close();
			}
			catch(Exception e) {
			}

			// 연결이 안된걸루 판단한다.
			this.IN_COMM = false;
		}
	}

	protected void setConnectionTimeout(int timeOfTimeout) {
		this.TIME_OUT = timeOfTimeout;
		try {
			this.CONNECTED_SOCKET.setSoTimeout(timeOfTimeout);
		}
		catch(Throwable e) {
			if (log.isDebugEnabled()) {
				log.error(e.getMessage());
			}
		}
	}
}
