/*
 * Created on 2005. 12. 6
 */
package pluto.mail.mx;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsByteArrayOutputStream;

/**
 * @author 이상근
 */
@Slf4j
public class TCPMXLookup extends MXLookup {

	protected Socket				CONNECTED_SOCKET	= null;

	protected TCPMXLookup() {
		super();
	}

	protected int getDNSResult(InetAddress address, byte[] query, eMsByteArrayOutputStream buffer) throws Throwable {
		int responseLength = -1;

		try {
			// DNS Server로 접속
			this.CONNECTED_SOCKET = new Socket(address, 53);
			setConnectionTimeout(5000);  // timeout 설정 추가(milliseconds)

			// 스트림을 생성한다.
			BufferedOutputStream bufferedOut = new BufferedOutputStream(this.CONNECTED_SOCKET.getOutputStream());
			DataOutputStream dataOut = new DataOutputStream(bufferedOut);

			InputStream bufferedIn = new BufferedInputStream(this.CONNECTED_SOCKET.getInputStream());
			DataInputStream dataIn = new DataInputStream(bufferedIn);

			dataOut.writeShort(query.length);
			dataOut.write(query);
			dataOut.flush();

			responseLength = dataIn.readUnsignedShort();

			buffer.ensureSize(responseLength);

			byte[] rawByte = buffer.getRawByteArray();

			dataIn.readFully(rawByte, 0, responseLength);
		}
		catch(Throwable thw) {
			throw thw;
		}
		finally {
			close();
		}

		return responseLength;
	}

	public void close() {
		this.CONNECT_HOST = null;

		this.IN_COMM = false;
		this.COMM_START_TIME = -1;

		killSession();

		this.CONNECTED_SOCKET = null;
	}

	public void killSession() {
		if( this.CONNECTED_SOCKET != null ) {
			try {

				this.CONNECTED_SOCKET.shutdownInput();
			}
			catch(Throwable e) {

			}

			try {

				this.CONNECTED_SOCKET.shutdownOutput();
			}
			catch(Throwable e) {

			}

			try {
				this.CONNECTED_SOCKET.close();
			}
			catch(Exception e) {
			}

			// 연결이 안된걸루 판단한다.
			this.IN_COMM = false;
		}
	}

	protected void setConnectionTimeout(int timeOfTimeout) {
		this.TIME_OUT = timeOfTimeout;
		try {
			this.CONNECTED_SOCKET.setSoTimeout(timeOfTimeout);
		}
		catch(Throwable e) {
			if (log.isDebugEnabled()) {
				log.error(e.getMessage());
			}
		}
	}
}
