/*
 * Created on 2005. 12. 6
 */
package pluto.mail.mx;

import java.net.InetAddress;
import java.net.UnknownHostException;

import lombok.extern.slf4j.Slf4j;

/**
 * @author 이상근
 */
@Slf4j
public class LookupUtil {
	private static final char	CHAR_0		= '0';

	private static final char	CHAR_9		= '9';

	private static final char	CHAR_DOT	= '.';

	public static int getPureDigitIP(String ip) {
		int dotCnt = 0;
		for (int i = 0; i < ip.length(); i++) {
			char tmpChar = ip.charAt(i);
			if( tmpChar == CHAR_DOT ){
				dotCnt++;
				continue;
			}
			else if((tmpChar >= CHAR_0 && tmpChar <= CHAR_9) ) {
				continue;
			}
			else {
				return 0;
			}
		}

		if(dotCnt != 3){
			return 0;
		}
		return getIntArray(ip);
	}

	public static int getIntIPToInetInt(int i1, int i2, int i3, int i4) {
		int iIP = 0;
		iIP += ((i4 & 0xFF) << 24);
		iIP += ((i3 & 0xFF) << 16);
		iIP += ((i2 & 0xFF) << 8);
		iIP += ((i1 & 0xFF) << 0);
		return iIP;
	}

	public static byte[] getIntToInetByteArray(int iIP) {
		byte[] returnValue = new byte[4];

		returnValue[0] = (byte) (iIP >>> 0);
		returnValue[1] = (byte) (iIP >>> 8);
		returnValue[2] = (byte) (iIP >>> 16);
		returnValue[3] = (byte) (iIP >>> 24);

		return returnValue;
	}

	public static String getIntIPToString(int iIP){
		return ((((iIP >>> 0)) & 0xFF) + "." + (((iIP >>> 8)) & 0xFF) + "." + ((iIP >>> 16) & 0xFF) + "." + (((iIP >>> 24)) & 0xFF));
	}
	/**
	 * IP base String 을 InetAddress로 전환한다.
	 * 
	 * @param addr
	 *            IP base Host Name
	 * @return java.net.InetAddress
	 * @throws UnknownHostException
	 *             엉뚱한 도메인을 넣거나 Domain Name base String을 잘 못 넣으면 발
	 */
	public static final InetAddress getInetAddress(int iIP) throws UnknownHostException {
		byte[] returnValue = getIntToInetByteArray(iIP);
		return InetAddress.getByAddress(returnValue);		
	}

	/**
	 * Long을 4 byte로 끊어서 읽으므로 Bits에서 이부분을 재 코딩함.
	 */
	public static long getLong(byte[] b, boolean high) {
		long returnValue = 0;
		if( high ) {
			returnValue += ((b[3] & 0xFFL) << 0);
			returnValue += ((b[2] & 0xFFL) << 8);
			returnValue += ((b[1] & 0xFFL) << 16);
			returnValue += ((b[0] & 0xFFL) << 24);
		}
		else {
			returnValue += ((b[3] & 0xFFL) << 32);
			returnValue += ((b[2] & 0xFFL) << 40);
			returnValue += ((b[1] & 0xFFL) << 48);
			returnValue += ((b[0] & 0xFFL) << 56);
		}
		return returnValue;
	}

	public static void putLong(long val, byte[] b, boolean high) {
		if( high ) {
			b[3] = (byte) (val >>> 0);
			b[2] = (byte) (val >>> 8);
			b[1] = (byte) (val >>> 16);
			b[0] = (byte) (val >>> 24);
		}
		else {
			b[3] = (byte) (val >>> 32);
			b[2] = (byte) (val >>> 40);
			b[1] = (byte) (val >>> 48);
			b[0] = (byte) (val >>> 56);
		}
	}

	/**
	 * IP base String 을 InetAddress로 전환한다.
	 * 
	 * @param addr
	 *            IP base Host Name
	 * @return java.net.InetAddress
	 * @throws UnknownHostException
	 *             엉뚱한 도메인을 넣거나 Domain Name base String을 잘 못 넣으면 발
	 */
	public static final InetAddress getInetAddress(String addr) throws UnknownHostException {
		byte[] returnValue = getByteArray(addr);
		return returnValue == null ? null : InetAddress.getByAddress(returnValue);
	}

	/**
	 * IP base Address를 InetAddress로 전환 가능한 byte array로 전환한다.
	 * 
	 * @param addr
	 *            IP base address
	 * @return byte array
	 */
	public static final byte[] getByteArray(String addr) {
		byte[] returnValue = new byte[4];

		int idx1 = addr.indexOf(".");

		if( idx1 < 0 ) {
			log.info("getRawAddr() FIND FIRST INDEX FAIL : {}", addr);
			return null;
		}

		// 첫번째 숫자를 더하고...
		returnValue[0] = (byte) (Integer.parseInt(addr.substring(0, idx1)) & 0xFF);

		idx1++;

		int idx2 = addr.indexOf(".", idx1);

		if( idx2 < 0 ) {
			log.info("getRawAddr() FIND SECOND INDEX FAIL :{}", addr);
			return null;
		}

		// 두번째 숫자를 더하고
		returnValue[1] = (byte) (Integer.parseInt(addr.substring(idx1, idx2)) & 0xFF);

		idx1 = idx2 + 1;

		idx2 = addr.indexOf('.', idx1);

		if( idx2 < 0 ) {
			log.info("NetAddress", "getRawAddr() FIND THIRD INDEX FAIL", addr);
			return null;
		}

		// 세번째 숫자를 더하
		returnValue[2] = (byte) (Integer.parseInt(addr.substring(idx1, idx2)) & 0xFF);

		// 네번째 숫자를 더하
		returnValue[3] = (byte) (Integer.parseInt(addr.substring(idx2 + 1)) & 0xFF);

		return returnValue;
	}

	/**
	 * IP base Address를 InetAddress로 전환 가능한 int array로 전환한다.
	 * 
	 * @param addr
	 *            IP base address
	 * @return int array
	 */
	private static final int getIntArray(String addr) {
		int idx1 = addr.indexOf(".");

		// 첫번째 숫자를 더하고...
		int i1 = Integer.parseInt(addr.substring(0, idx1));

		idx1++;

		int idx2 = addr.indexOf(".", idx1);

		// 두번째 숫자를 더하고
		int i2 = Integer.parseInt(addr.substring(idx1, idx2));

		idx1 = idx2 + 1;

		idx2 = addr.indexOf(".", idx1);

		// 세번째 숫자를 더하
		int i3 = Integer.parseInt(addr.substring(idx1, idx2));

		// 네번째 숫자를 더하
		int i4 = Integer.parseInt(addr.substring(idx2 + 1));

		return getIntIPToInetInt(i1,i2,i3,i4);
	}

	/**
	 * IP address를 나타내는 byte array를 IP base String으로 전환한다.
	 * 
	 * @param addr
	 *            byte array
	 * @return IP base String
	 */
	public static String toDottedQuad(byte[] addr) {
		return ((addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[3] & 0xFF));
	}

	public static void main(String[] args) throws Exception {
		int a = 0;

		log.debug(toDottedQuad(getIntToInetByteArray(a)));
	}
}
